/*
 * Decompiled with CFR 0.152.
 */
package com.devdaily.system;

import com.devdaily.system.ThreadedStreamHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class SystemCommandExecutor {
    private List<String> commandInformation;
    private String adminPassword;
    private ThreadedStreamHandler inputStreamHandler;
    private ThreadedStreamHandler errorStreamHandler;

    public SystemCommandExecutor(String ... commandInformation) {
        if (commandInformation == null) {
            throw new NullPointerException("The commandInformation is required.");
        }
        this.commandInformation = Arrays.asList(commandInformation);
        this.adminPassword = null;
    }

    public int executeCommand() throws IOException, InterruptedException {
        int exitValue = -99;
        try {
            ProcessBuilder pb = new ProcessBuilder(this.commandInformation);
            Process process = pb.start();
            OutputStream stdOutput = process.getOutputStream();
            InputStream inputStream = process.getInputStream();
            InputStream errorStream = process.getErrorStream();
            this.inputStreamHandler = new ThreadedStreamHandler(inputStream, stdOutput, this.adminPassword);
            this.errorStreamHandler = new ThreadedStreamHandler(errorStream);
            this.inputStreamHandler.start();
            this.errorStreamHandler.start();
            exitValue = process.waitFor();
            this.inputStreamHandler.interrupt();
            this.errorStreamHandler.interrupt();
            this.inputStreamHandler.join();
            this.errorStreamHandler.join();
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        return exitValue;
    }

    public StringBuilder getStandardOutputFromCommand() {
        return this.inputStreamHandler.getOutputBuffer();
    }

    public StringBuilder getStandardErrorFromCommand() {
        return this.errorStreamHandler.getOutputBuffer();
    }
}

