/*
 * Decompiled with CFR 0.152.
 */
package org.javad.components;

import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import org.javad.components.UIHelper;

public class ImageThumbnail
extends JLabel {
    public static final int PREVIEW_SIZE = 80;
    public static final int IMAGE_PADDING = 4;
    private BufferedImage image;
    private int preview_size = 80;

    public ImageThumbnail() {
    }

    public ImageThumbnail(Image image) {
        this(image, 80);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public ImageThumbnail(Image image, int size) {
        this();
        this.setSize(size);
        this.setImage(image);
    }

    public void setSize(int size) {
        this.preview_size = size;
    }

    public void setImage(Image value) {
        if (value instanceof BufferedImage) {
            this.image = (BufferedImage)value;
            this.setIcon(UIHelper.getScaledIcon(this.image, this.preview_size, 4));
        } else {
            this.image = null;
            this.setIcon(null);
        }
        this.repaint();
    }
}

