/*
 * Decompiled with CFR 0.152.
 */
package org.javad.components;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import org.javad.components.UIHelper;
import org.jdesktop.swingx.action.OpenBrowserAction;

public class LinkLabel
extends JLabel {
    private static final String A_HREF = "<a href=\"";
    private static final String HREF_CLOSED = "\">";
    private static final String HREF_END = "</a>";

    public LinkLabel() {
        this("");
    }

    public LinkLabel(String text) {
        if (UIHelper.isBrowsingSupported()) {
            this.setCursor(new Cursor(12));
            this.addMouseListener(new LinkMouseListener());
        }
    }

    @Override
    public void setText(String text) {
        super.setText(UIHelper.isBrowsingSupported() ? UIHelper.convertToMultiline(this.generateAsLink(text)) : text);
    }

    protected String convertToPlainText(String s) {
        return s.substring(s.indexOf(A_HREF) + A_HREF.length(), s.indexOf(HREF_CLOSED));
    }

    protected String generateAsLink(String s) {
        return A_HREF.concat(s).concat(HREF_CLOSED).concat(s).concat(HREF_END);
    }

    private class LinkMouseListener
    extends MouseAdapter {
        private long clickTime = 0L;

        private LinkMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            JLabel l = (JLabel)evt.getSource();
            if (evt.getWhen() - this.clickTime < 2000L) {
                return;
            }
            OpenBrowserAction browser = new OpenBrowserAction(LinkLabel.this.convertToPlainText(l.getText()));
            browser.actionPerformed(new ActionEvent(l, evt.getID(), Desktop.Action.BROWSE.toString()));
            this.clickTime = evt.getWhen();
        }
    }
}

