/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.javad.pdf.IPositionalContent;
import org.javad.pdf.model.PageConfiguration;

public abstract class PositionalContent
implements IPositionalContent {
    private float x;
    private float y;
    protected PageConfiguration configuration;
    protected Set<String> skipTerms = new HashSet<String>();

    public PositionalContent(PageConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    public void parseSkipTerms(String text) {
        this.skipTerms.clear();
        if (text != null && !text.isEmpty()) {
            this.skipTerms.addAll(Arrays.asList(text.split(" ")));
        }
    }

    @Override
    public boolean isSkipped() {
        Set<String> terms = this.configuration.getSkipTerms();
        if (!terms.isEmpty()) {
            for (String term : this.skipTerms) {
                if (!terms.contains(term)) continue;
                return true;
            }
        }
        return false;
    }
}

