/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.fonts;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.fonts.PdfFontDefinition;
import org.javad.pdf.fonts.PdfFontMapping;

public class PdfFontBean
implements Comparable<PdfFontBean> {
    private PdfFontMapping reference;
    private String fontFamily;
    private PdfFontDefinition definition;
    private float size;
    private int style;
    private boolean i18n = false;
    private boolean system = true;
    private static final Logger logger = Logger.getLogger(PdfFontBean.class.getName());

    public PdfFontBean(PdfFontDefinition definition, PdfFontMapping font) {
        this();
        this.definition = definition;
        this.reference = font;
    }

    public PdfFontBean() {
    }

    public boolean isI18N() {
        return this.i18n;
    }

    public void setI18N(boolean i18N) {
        this.i18n = i18N;
    }

    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public PdfFontMapping getFontMapping() {
        return this.reference;
    }

    public void setFontMapping(PdfFontMapping font) {
        this.reference = font;
        this.setSystem(false);
    }

    public PdfFontDefinition getFontDefinition() {
        return this.definition;
    }

    public void setFontDefinition(PdfFontDefinition usage) {
        this.definition = usage;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public boolean isBold() {
        return (this.style & 1) > 0;
    }

    public boolean isItalic() {
        return (this.style & 2) > 0;
    }

    public boolean isUnderline() {
        return (this.style & 4) > 0;
    }

    public String asString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append(Boolean.valueOf(this.system).toString()).append("\uffff");
        buf.append(this.system ? this.fontFamily : this.reference.getFontAlias()).append("\uffff");
        buf.append(this.size).append("\uffff");
        buf.append(this.style).append("\uffff");
        return buf.toString();
    }

    public static PdfFontBean fromString(String str) {
        PdfFontBean bean = new PdfFontBean();
        String[] values = str.split("\uffff");
        if (values.length < 4) {
            throw new IllegalArgumentException("The value \"" + str + "\" is not a valid serialized font bean.");
        }
        bean.setSystem(Boolean.valueOf(values[0]));
        String family = values[1];
        if (bean.isSystem()) {
            bean.setFontFamily(family);
        } else {
            for (PdfFontMapping mapping : FontRegistry.getInstance().getFontMappings()) {
                if (!mapping.getFontAlias().equals(family)) continue;
                bean.setFontMapping(mapping);
                break;
            }
            if (bean.getFontMapping() == null) {
                logger.log(Level.WARNING, "The font mapped to alias \"" + family + "\" was not found in the registered font mappings.");
            }
        }
        bean.setSize(Float.valueOf(values[2]).floatValue());
        bean.setStyle(Integer.valueOf(values[3]));
        return bean;
    }

    @Override
    public int compareTo(PdfFontBean o) {
        return this.getFontDefinition().toString().compareTo(o.getFontDefinition().toString());
    }
}

