/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.fonts;

public enum PdfFontDefinition {
    AlbumTitle,
    AlbumSubtitle,
    AlbumDescription,
    AlbumContents,
    Title,
    Subtitle,
    Classifier,
    SetIssue,
    CompositeSetDescription,
    SetDescription,
    SetDescriptionSecondary,
    SetComment,
    RowDescription,
    Stampbox,
    StampboxOther,
    ExtendedCharacters;


    public String getDefaultTypeFace() {
        String typeFace;
        switch (this) {
            case Title: 
            case Subtitle: 
            case AlbumTitle: 
            case AlbumSubtitle: {
                typeFace = "CastleTLig";
                break;
            }
            case ExtendedCharacters: {
                typeFace = "Arial Unicode MS";
                break;
            }
            case StampboxOther: 
            case RowDescription: 
            case CompositeSetDescription: 
            case SetComment: 
            case SetDescriptionSecondary: {
                typeFace = "Verdana";
                break;
            }
            default: {
                typeFace = "Verdana";
            }
        }
        return typeFace;
    }

    public int getDefaultStyle() {
        int style = 0;
        switch (this) {
            case StampboxOther: 
            case RowDescription: 
            case CompositeSetDescription: 
            case SetComment: 
            case SetDescriptionSecondary: 
            case AlbumDescription: {
                style = 2;
            }
        }
        return style;
    }

    public float getDefaultSize() {
        float size = 4.5f;
        switch (this) {
            case AlbumTitle: {
                size = 36.0f;
                break;
            }
            case Title: 
            case AlbumSubtitle: {
                size = 24.0f;
                break;
            }
            case Subtitle: {
                size = 12.0f;
                break;
            }
            case Classifier: {
                size = 7.5f;
                break;
            }
            case AlbumDescription: 
            case SetIssue: {
                size = 6.5f;
            }
        }
        return size;
    }
}

