/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.fonts;

import com.itextpdf.text.pdf.BaseFont;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javad.stamp.pdf.Resources;

public class PdfFontMapping {
    private String filePath;
    private String fontAlias;
    private boolean needsValidation = true;
    private boolean valid = false;
    private String validationMessage = null;
    private static final Logger logger = Logger.getLogger(PdfFontMapping.class.getName());

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
        this.needsValidation = true;
    }

    public String getFontAlias() {
        return this.fontAlias;
    }

    public void setFontAlias(String fontName) {
        this.fontAlias = fontName;
        this.needsValidation = true;
    }

    public boolean validate() {
        if (!this.needsValidation) {
            return this.valid;
        }
        this.valid = false;
        if (this.filePath != null && this.fontAlias != null) {
            try {
                BaseFont bf = BaseFont.createFont(this.getFilePath(), "UTF-8", true, false, null, null, false);
                if (bf != null) {
                    this.valid = true;
                }
            }
            catch (Exception e) {
                this.validationMessage = MessageFormat.format(Resources.getString("message.font.fontNotValid"), e.getMessage());
                logger.log(Level.FINE, "Issue registering the font \"" + this.fontAlias + "\" for path \"" + this.filePath + "\"", e);
            }
        } else {
            this.validationMessage = Resources.getString("message.font.invalidValue");
        }
        if (this.valid) {
            this.validationMessage = null;
        }
        this.needsValidation = false;
        return this.valid;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public String toString() {
        return this.fontAlias + " - " + this.filePath;
    }
}

