/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.fonts.io;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.javad.stamp.pdf.Resources;

public class PdfFontFileFilter
extends FileFilter
implements FilenameFilter {
    private FilterMode mode;

    public PdfFontFileFilter(FilterMode mode) {
        this.mode = mode;
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.acceptFilename(name.toLowerCase());
    }

    @Override
    public boolean accept(File f) {
        boolean accept;
        boolean bl = accept = f.isDirectory() && f.canRead();
        if (!accept) {
            accept = f.isFile() && this.acceptFilename(f.getName().toLowerCase());
        }
        return accept;
    }

    private boolean acceptFilename(String name) {
        boolean accept = false;
        switch (this.mode) {
            case OTF: {
                accept = name.endsWith(".otf");
                break;
            }
            case TTF: {
                accept = name.endsWith(".ttf") || name.endsWith(".ttc");
                break;
            }
            case ALL: {
                accept = name.endsWith(".ttf") || name.endsWith(".ttc") || name.endsWith(".otf");
            }
        }
        return accept;
    }

    @Override
    public String getDescription() {
        switch (this.mode) {
            case OTF: {
                return Resources.getString("filter.otf");
            }
            case TTF: {
                return Resources.getString("filter.ttf");
            }
        }
        return Resources.getString("filter.fonts");
    }

    public static JFileChooser getFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        for (FilterMode mode : FilterMode.values()) {
            fileChooser.addChoosableFileFilter(new PdfFontFileFilter(mode));
        }
        return fileChooser;
    }

    public static enum FilterMode {
        OTF,
        TTF,
        ALL;

    }
}

