/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.fonts.ui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.javad.components.ISettingsPanel;
import org.javad.components.MessagePanel;
import org.javad.components.UIHelper;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.fonts.PdfFontMapping;
import org.javad.pdf.fonts.ui.PdfFontMappingEditor;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.events.PdfAppEvent;

public class FontMappingPanel
extends JPanel
implements ISettingsPanel {
    private JPanel panel;
    private JButton btnNewRefButton;
    private JScrollPane fontTableScrollPane;
    private JTable fontTable;
    private MessagePanel messagePanel;
    private JButton btnEditRefButton;
    private PdfFontMappingEditor editor;
    private FontReferenceTableModel tableRefModel;
    private JLabel fontPathLabel;
    private JLabel fontPathValueLabel;
    private static final Logger logger = Logger.getLogger(FontMappingPanel.class.getName());
    private JButton btnDeleteRefButton;

    public FontMappingPanel() {
        AnnotationProcessor.process((Object)this);
        this.setOpaque(false);
        this.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("40dlu"), FormFactory.UNRELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.PREF_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode("85dlu:grow"), FormFactory.UNRELATED_GAP_ROWSPEC}));
        this.add((Component)this.getMessagePanel(), "2, 2, 5, 1, fill, fill");
        this.add((Component)this.getFontPathLabel(), "2, 4, right, top");
        this.add((Component)this.getFontPathValueLabel(), "4, 4, fill, default");
        this.add((Component)this.getPanel(), "2, 6, 5, 1, fill, fill");
        this.add((Component)this.getFontTableScrollPane(), "2, 7, 5, 1, fill, fill");
    }

    @EventSubscriber(eventClass=PdfAppEvent.class)
    public void handleAppEvent(PdfAppEvent event) {
        if (event.getType() == PdfAppEvent.EventType.FontReferenceSave) {
            FontReferenceTableModel tModel = this.getTableRefModel();
            tModel.addFontReference((PdfFontMapping)event.getData());
        } else if (event.getType() == PdfAppEvent.EventType.FontReferenceEdit) {
            FontReferenceTableModel tModel = this.getTableRefModel();
            tModel.setFontReference((PdfFontMapping)event.getData());
        }
    }

    public void loadSettings() {
        Collection<PdfFontMapping> mappings = FontRegistry.getInstance().getFontMappings();
        this.getTableRefModel().clear();
        for (PdfFontMapping mapping : mappings) {
            this.getTableRefModel().addFontReference(mapping);
        }
    }

    public void saveSettings() {
        List<PdfFontMapping> mappings = this.getTableRefModel().getFontReferences();
        FontRegistry.getInstance().setFontMappings(mappings);
    }

    protected JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setOpaque(false);
            FlowLayout flowLayout = (FlowLayout)this.panel.getLayout();
            flowLayout.setHgap(0);
            flowLayout.setAlignment(0);
            flowLayout.setVgap(0);
            this.panel.setPreferredSize(new Dimension(100, 26));
            this.panel.add(this.getBtnNewRefButton());
            this.panel.add(this.getBtnEditRefButton());
            this.panel.add(this.getBtnDeleteRefButton());
        }
        return this.panel;
    }

    protected JButton getBtnNewRefButton() {
        if (this.btnNewRefButton == null) {
            this.btnNewRefButton = new JButton();
            this.btnNewRefButton.setName("btn-fontMapping-new");
            this.btnNewRefButton.setAction(new CreateFontReferenceAction());
        }
        return this.btnNewRefButton;
    }

    protected JButton getBtnEditRefButton() {
        if (this.btnEditRefButton == null) {
            this.btnEditRefButton = new JButton();
            this.btnEditRefButton.setName("btn-fontMapping-edit");
            this.btnEditRefButton.setAction(new EditFontReferenceAction());
        }
        return this.btnEditRefButton;
    }

    protected JButton getBtnDeleteRefButton() {
        if (this.btnDeleteRefButton == null) {
            this.btnDeleteRefButton = new JButton();
            this.btnDeleteRefButton.setName("btn-fontMapping-delete");
            this.btnDeleteRefButton.setAction(new DeleteFontMappingAction());
        }
        return this.btnDeleteRefButton;
    }

    protected PdfFontMappingEditor getPdfFontReferenceEditor() {
        if (this.editor == null) {
            this.editor = new PdfFontMappingEditor();
        }
        return this.editor;
    }

    protected JScrollPane getFontTableScrollPane() {
        if (this.fontTableScrollPane == null) {
            this.fontTableScrollPane = new JScrollPane();
            this.fontTableScrollPane.setViewportView(this.getFontReferenceTable());
        }
        return this.fontTableScrollPane;
    }

    protected JTable getFontReferenceTable() {
        if (this.fontTable == null) {
            this.fontTable = new JTable(this.getTableRefModel());
            this.fontTable.setColumnModel(this.getFontReferenceTableColumnModel());
            this.fontTable.setRowHeight(22);
            this.fontTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    boolean enabled = FontMappingPanel.this.getFontReferenceTable().getSelectedRow() > -1;
                    FontMappingPanel.this.getBtnEditRefButton().getAction().setEnabled(enabled);
                    FontMappingPanel.this.getBtnDeleteRefButton().getAction().setEnabled(enabled);
                }
            });
            this.fontTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        FontMappingPanel.this.getBtnEditRefButton().getAction().actionPerformed(new ActionEvent(FontMappingPanel.this.getFontReferenceTable(), 5, "edit"));
                    }
                }
            });
        }
        return this.fontTable;
    }

    protected FontReferenceTableModel getTableRefModel() {
        if (this.tableRefModel == null) {
            this.tableRefModel = new FontReferenceTableModel();
        }
        return this.tableRefModel;
    }

    protected TableColumnModel getFontReferenceTableColumnModel() {
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        TableColumn validCol = new TableColumn(FontReferenceColumns.Valid.ordinal());
        validCol.setHeaderValue(FontReferenceColumns.Valid.getColumnHeader());
        validCol.setWidth(42);
        validCol.setMaxWidth(42);
        validCol.setCellRenderer(new ValidateColumnRenderer());
        TableColumn aliasCol = new TableColumn(FontReferenceColumns.Alias.ordinal());
        aliasCol.setPreferredWidth(70);
        aliasCol.setHeaderValue(FontReferenceColumns.Alias.getColumnHeader());
        TableColumn pathCol = new TableColumn(FontReferenceColumns.Path.ordinal());
        pathCol.setHeaderValue(FontReferenceColumns.Path.getColumnHeader());
        pathCol.setPreferredWidth(140);
        tcm.addColumn(validCol);
        tcm.addColumn(aliasCol);
        tcm.addColumn(pathCol);
        return tcm;
    }

    protected MessagePanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messagePanel = new MessagePanel(UIHelper.convertToMultiline((String)Resources.getString("message.fontMapping.helpText")));
            this.messagePanel.setPreferredSize(new Dimension(100, 70));
        }
        return this.messagePanel;
    }

    protected JLabel getFontPathLabel() {
        if (this.fontPathLabel == null) {
            this.fontPathLabel = new JLabel(Resources.getString("label.fontSystemPath"));
        }
        return this.fontPathLabel;
    }

    protected JLabel getFontPathValueLabel() {
        if (this.fontPathValueLabel == null) {
            String nativePath = FontRegistry.getInstance().getFontPath();
            String path = nativePath != null ? nativePath : "unknown";
            String msg = MessageFormat.format(Resources.getString("message.fontPath.value"), path, GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames().length);
            this.fontPathValueLabel = new JLabel(msg);
        }
        return this.fontPathValueLabel;
    }

    protected class FontReferenceTableModel
    extends AbstractTableModel {
        List<PdfFontMapping> fontReferences = new ArrayList<PdfFontMapping>();

        protected FontReferenceTableModel() {
        }

        public void clear() {
            this.fontReferences.clear();
            this.fireTableDataChanged();
        }

        public void remove(PdfFontMapping ref) {
            int index = -1;
            for (int i = 0; i < this.fontReferences.size(); ++i) {
                if (!this.fontReferences.get(i).equals(ref)) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                this.fontReferences.remove(index);
                this.fireTableRowsDeleted(index, index);
            }
        }

        @Override
        public int getRowCount() {
            return this.fontReferences.size();
        }

        public void addFontReference(PdfFontMapping ref) {
            this.setFontReference(ref, this.getRowCount());
        }

        public void setFontReference(PdfFontMapping ref) {
            for (int i = 0; i < this.fontReferences.size(); ++i) {
                if (!this.fontReferences.get(i).equals(ref)) continue;
                this.setFontReference(ref, i);
                break;
            }
        }

        public void setFontReference(PdfFontMapping ref, int row) {
            if (row < this.fontReferences.size()) {
                this.fontReferences.set(row, ref);
                this.fireTableRowsUpdated(row, row);
            } else {
                this.fontReferences.add(ref);
                this.fireTableRowsInserted(row, row);
            }
        }

        public List<PdfFontMapping> getFontReferences() {
            return this.fontReferences;
        }

        public PdfFontMapping getFontReference(int row) {
            return this.fontReferences.get(row);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FontReferenceColumns col = FontReferenceColumns.values()[columnIndex];
            PdfFontMapping value = this.fontReferences.get(rowIndex);
            switch (col) {
                case Valid: {
                    return value;
                }
                case Alias: {
                    return value.getFontAlias();
                }
                case Path: {
                    return value.getFilePath();
                }
            }
            return "";
        }
    }

    static enum FontReferenceColumns {
        Valid,
        Alias,
        Path;


        String getColumnHeader() {
            switch (this) {
                case Valid: {
                    return Resources.getString("table.header.fontReferenceValid");
                }
                case Alias: {
                    return Resources.getString("table.header.fontReferenceAlias");
                }
                case Path: {
                    return Resources.getString("table.header.fontReferencePath");
                }
            }
            return "";
        }
    }

    public class ValidateColumnRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel && value instanceof PdfFontMapping) {
                JLabel label = (JLabel)comp;
                PdfFontMapping ref = (PdfFontMapping)value;
                boolean valid = ref.validate();
                label.setIcon(Resources.getIcon(valid ? "icon.font.valid" : "icon.font.invalid"));
                label.setText("");
                label.setToolTipText(Resources.getString(valid ? "message.valid" : ref.getValidationMessage()));
                comp = label;
            }
            return comp;
        }
    }

    private class CreateFontReferenceAction
    extends AbstractAction {
        public CreateFontReferenceAction() {
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.newFont.small"));
            this.putValue("ShortDescription", Resources.getString("label.fontCreateReference.tooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FontMappingPanel.this.getPdfFontReferenceEditor().setReferenceModel(null);
            FontMappingPanel.this.getPdfFontReferenceEditor().setVisible(true);
        }
    }

    private class EditFontReferenceAction
    extends AbstractAction {
        public EditFontReferenceAction() {
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.editFont.small"));
            this.putValue("ShortDescription", Resources.getString("label.fontEditReference.tooltip"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PdfFontMapping ref = FontMappingPanel.this.getTableRefModel().getFontReference(FontMappingPanel.this.getFontReferenceTable().getSelectedRow());
            FontMappingPanel.this.getPdfFontReferenceEditor().setReferenceModel(ref);
            FontMappingPanel.this.getPdfFontReferenceEditor().setVisible(true);
        }
    }

    private class DeleteFontMappingAction
    extends AbstractAction {
        public DeleteFontMappingAction() {
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.deleteFont.small"));
            this.putValue("ShortDescription", Resources.getString("label.fontDeleteMapping.tooltip"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PdfFontMapping ref = FontMappingPanel.this.getTableRefModel().getFontReference(FontMappingPanel.this.getFontReferenceTable().getSelectedRow());
            FontMappingPanel.this.getTableRefModel().remove(ref);
        }
    }
}

