/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.fonts.ui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import org.javad.components.MessagePanel;
import org.javad.components.UIHelper;
import org.javad.pdf.fonts.PdfFontMapping;
import org.javad.pdf.fonts.io.PdfFontFileFilter;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.events.PdfAppEvent;
import pub.domain.GradientPanel;

public class PdfFontMappingEditor
extends JDialog {
    private JPanel contentPanel;
    private JPanel buttonPanel;
    private JButton btnOk;
    private JButton btnCancel;
    private JLabel aliasLabel;
    private JTextField aliasText;
    private JLabel fontLabel;
    private JTextField fontText;
    private JButton btnFontPicker;
    private MessagePanel messagePanel;
    private GradientPanel dialogPanel;
    private PdfFontMapping model;
    private boolean edit = false;
    private static final Logger logger = Logger.getLogger(PdfFontMappingEditor.class.getName());

    public PdfFontMappingEditor() {
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource(Resources.getIconName("icon.font.small"))));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "There was an error setting the icon for the editor", e);
        }
        this.setSize(new Dimension(450, 270));
        this.setModal(true);
        this.setBackground(UIHelper.Medium_Grey);
        this.setForeground(UIHelper.Dark_Grey);
        this.setTitle(Resources.getString("title.fontReference"));
        this.dialogPanel = new GradientPanel();
        this.dialogPanel.setDirection(0);
        this.dialogPanel.setBackground(new Color(248, 248, 255));
        this.dialogPanel.setForeground(Color.LIGHT_GRAY);
        this.dialogPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.dialogPanel.add((Component)this.getContentPanel(), (Object)"Center");
        this.dialogPanel.add((Component)this.getButtonPanel(), (Object)"South");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add((Component)this.dialogPanel);
    }

    public void setReferenceModel(PdfFontMapping reference) {
        if (reference == null) {
            reference = new PdfFontMapping();
            this.edit = false;
        } else {
            this.edit = true;
        }
        this.model = reference;
        this.getAliasText().setText(this.edit ? reference.getFontAlias() : "");
        this.getFontText().setText(this.edit ? reference.getFilePath() : "");
        this.validateReference();
    }

    public PdfFontMapping getReferenceModel() {
        return this.model;
    }

    protected JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setOpaque(false);
            this.contentPanel.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("32dlu"), FormFactory.UNRELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.PREF_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("24dlu"), RowSpec.decode("1dlu"), RowSpec.decode("24dlu"), FormFactory.UNRELATED_GAP_ROWSPEC}));
            this.contentPanel.add((Component)this.getMessagePanel(), "2, 2, 5, 1, fill, fill");
            this.contentPanel.add((Component)this.getAliasLabel(), "2, 4, right, default");
            this.contentPanel.add((Component)this.getAliasText(), "4, 4, left, default");
            this.contentPanel.add((Component)this.getFontLabel(), "2, 6, right, default");
            this.contentPanel.add((Component)this.getFontText(), "4, 6, fill, default");
            this.contentPanel.add((Component)this.getBtnFontPicker(), "6, 6");
        }
        return this.contentPanel;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setRequestFocusEnabled(false);
            this.buttonPanel.setOpaque(false);
            FlowLayout fl_buttonPanel = (FlowLayout)this.buttonPanel.getLayout();
            fl_buttonPanel.setVgap(15);
            fl_buttonPanel.setAlignment(2);
            this.buttonPanel.setPreferredSize(new Dimension(100, 50));
            this.buttonPanel.add(this.getBtnOk());
            this.buttonPanel.add(this.getBtnCancel());
        }
        return this.buttonPanel;
    }

    protected JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton(Resources.getString("button.ok"));
            this.btnOk.setPreferredSize(new Dimension(75, 24));
            this.btnOk.setName("btn-fontReferenceEditor-ok");
            this.btnOk.setAction(new SaveReferenceAction());
        }
        return this.btnOk;
    }

    protected JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton(Resources.getString("button.cancel"));
            this.btnCancel.setPreferredSize(new Dimension(75, 24));
            this.btnCancel.setName("btn-fontReferenceEditor-cancel");
            this.btnCancel.setAction(new CancelReferenceAction());
        }
        return this.btnCancel;
    }

    protected JLabel getAliasLabel() {
        if (this.aliasLabel == null) {
            this.aliasLabel = new JLabel(Resources.getString("label.fontAlias"));
        }
        return this.aliasLabel;
    }

    protected JTextField getAliasText() {
        if (this.aliasText == null) {
            this.aliasText = new JTextField();
            this.aliasText.setMinimumSize(new Dimension(150, 24));
            this.aliasText.setPreferredSize(new Dimension(250, 24));
            this.aliasText.setText("");
            this.aliasText.setColumns(20);
            this.aliasText.getDocument().addDocumentListener(new ValidatingDocumentListener());
        }
        return this.aliasText;
    }

    protected JLabel getFontLabel() {
        if (this.fontLabel == null) {
            this.fontLabel = new JLabel(Resources.getString("label.fontPath"));
        }
        return this.fontLabel;
    }

    protected JTextField getFontText() {
        if (this.fontText == null) {
            this.fontText = new JTextField();
            this.fontText.setBackground(new Color(240, 240, 240));
            this.fontText.setEditable(false);
            this.fontText.setPreferredSize(new Dimension(100, 24));
            this.fontText.setText("");
            this.fontText.setColumns(10);
            this.fontText.getDocument().addDocumentListener(new ValidatingDocumentListener());
        }
        return this.fontText;
    }

    public boolean validateReference() {
        return !this.getFontText().getText().isEmpty() && !this.getAliasText().getText().isEmpty();
    }

    protected JButton getBtnFontPicker() {
        if (this.btnFontPicker == null) {
            this.btnFontPicker = new JButton();
            this.btnFontPicker.setPreferredSize(new Dimension(32, 26));
            this.btnFontPicker.setName("btn-fontReference-fontPicker");
            this.btnFontPicker.setAction(new FontPickerAction());
        }
        return this.btnFontPicker;
    }

    protected MessagePanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messagePanel = new MessagePanel(UIHelper.convertToMultiline((String)Resources.getString("message.fontReference.helpText")));
        }
        return this.messagePanel;
    }

    private class FontPickerAction
    extends AbstractAction {
        public FontPickerAction() {
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.font.picker"));
            this.putValue("ShortDescription", Resources.getString("label.font.picker"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f;
            JFileChooser chooser = PdfFontFileFilter.getFileChooser();
            if (0 == chooser.showOpenDialog(PdfFontMappingEditor.this.getBtnFontPicker()) && (f = chooser.getSelectedFile()) != null) {
                PdfFontMappingEditor.this.getFontText().setText(f.getAbsolutePath());
            }
        }
    }

    private class SaveReferenceAction
    extends AbstractAction {
        public SaveReferenceAction() {
            this.putValue("Name", Resources.getString("button.ok"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            logger.finer("Saving reference: " + PdfFontMappingEditor.this.getReferenceModel().toString());
            EventBus.publish((Object)new PdfAppEvent(PdfFontMappingEditor.this.edit ? PdfAppEvent.EventType.FontReferenceEdit : PdfAppEvent.EventType.FontReferenceSave, PdfFontMappingEditor.this.getReferenceModel()));
            PdfFontMappingEditor.this.setVisible(false);
        }
    }

    private class CancelReferenceAction
    extends AbstractAction {
        public CancelReferenceAction() {
            this.putValue("Name", Resources.getString("button.cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PdfFontMappingEditor.this.setVisible(false);
        }
    }

    protected class ValidatingDocumentListener
    implements DocumentListener {
        protected ValidatingDocumentListener() {
        }

        private void updateField(DocumentEvent e) {
            if (PdfFontMappingEditor.this.getAliasText().getDocument().equals(e.getDocument())) {
                PdfFontMappingEditor.this.getReferenceModel().setFontAlias(PdfFontMappingEditor.this.getAliasText().getText());
            } else if (PdfFontMappingEditor.this.getFontText().getDocument().equals(e.getDocument())) {
                PdfFontMappingEditor.this.getReferenceModel().setFilePath(PdfFontMappingEditor.this.getFontText().getText());
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateField(e);
            PdfFontMappingEditor.this.getBtnOk().getAction().setEnabled(PdfFontMappingEditor.this.validateReference());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateField(e);
            PdfFontMappingEditor.this.getBtnOk().getAction().setEnabled(PdfFontMappingEditor.this.validateReference());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateField(e);
            PdfFontMappingEditor.this.getBtnOk().getAction().setEnabled(PdfFontMappingEditor.this.validateReference());
        }
    }
}

