/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.javad.stamp.pdf.Resources;

public class PageConfiguration {
    private static final Logger logger = Logger.getLogger(PageConfiguration.class.getName());
    private String name;
    private String displayName;
    private boolean systemConfiguration = false;
    private float width;
    private float height;
    private float marginLeft;
    private float marginTop;
    private float marginBottom;
    private float marginRight;
    private float verticalSpacing;
    private float horizontalSpacing;
    private Set<String> skipTerms = new HashSet<String>();
    public static String DISPLAY_NAME = "displayName";
    public static String WIDTH = "page.width";
    public static String HEIGHT = "page.height";
    public static String MARGIN_LEFT = "margin.left";
    public static String MARGIN_TOP = "margin.top";
    public static String MARGIN_RIGHT = "margin.right";
    public static String MARGIN_BOTTOM = "margin.bottom";
    public static String HORIZONTAL_SPACING = "spacing.box.horizontal";
    public static String VERTICAL_SPACING = "spacing.box.vertical";

    void load() {
        Preferences prefs = Resources.getPreferencesNode().node(this.name);
        Properties defaults = new Properties();
        try {
            if (this.name == null) {
                throw new IllegalStateException("The name is not set for the configuration");
            }
            InputStream in = this.getClass().getResourceAsStream("/META-INF/" + this.name + "-settings.xml");
            if (in != null) {
                defaults.loadFromXML(in);
                this.systemConfiguration = true;
            }
        }
        catch (IOException ie) {
            logger.log(Level.WARNING, "The settings file was not found.", ie);
        }
        this.setDisplayName(defaults.getProperty(DISPLAY_NAME, null));
        this.setWidth(prefs.getFloat(WIDTH, Float.valueOf(defaults.containsKey(WIDTH) ? defaults.getProperty(WIDTH) : "0").floatValue()));
        this.setHeight(prefs.getFloat(HEIGHT, Float.valueOf(defaults.containsKey(HEIGHT) ? defaults.getProperty(HEIGHT) : "0").floatValue()));
        this.setMarginLeft(prefs.getFloat(MARGIN_LEFT, Float.valueOf(defaults.containsKey(MARGIN_LEFT) ? defaults.getProperty(MARGIN_LEFT) : "0").floatValue()));
        this.setMarginTop(prefs.getFloat(MARGIN_TOP, Float.valueOf(defaults.containsKey(MARGIN_TOP) ? defaults.getProperty(MARGIN_TOP) : "0").floatValue()));
        this.setMarginRight(prefs.getFloat(MARGIN_RIGHT, Float.valueOf(defaults.containsKey(MARGIN_RIGHT) ? defaults.getProperty(MARGIN_RIGHT) : "0").floatValue()));
        this.setMarginBottom(prefs.getFloat(MARGIN_BOTTOM, Float.valueOf(defaults.containsKey(MARGIN_BOTTOM) ? defaults.getProperty(MARGIN_BOTTOM) : "0").floatValue()));
        this.setHorizontalSpacing(prefs.getFloat(HORIZONTAL_SPACING, Float.valueOf(defaults.containsKey(HORIZONTAL_SPACING) ? defaults.getProperty(HORIZONTAL_SPACING) : "0").floatValue()));
        this.setVerticalSpacing(prefs.getFloat(VERTICAL_SPACING, Float.valueOf(defaults.containsKey(VERTICAL_SPACING) ? defaults.getProperty(VERTICAL_SPACING) : "0").floatValue()));
    }

    public boolean isSystemConfiguration() {
        return this.systemConfiguration;
    }

    void revert() {
        Preferences prefs = Resources.getPreferencesNode().node(this.name);
        try {
            prefs.removeNode();
            Resources.getPreferencesNode().remove(this.name);
        }
        catch (BackingStoreException e) {
            logger.log(Level.WARNING, "The preference for " + this.name + " was unable to be reverted.", e);
        }
        this.load();
    }

    void save() {
        Preferences prefs = Resources.getPreferencesNode().node(this.name);
        prefs.putFloat(WIDTH, this.getWidth());
        prefs.putFloat(HEIGHT, this.getHeight());
        prefs.putFloat(MARGIN_LEFT, this.getMarginLeft());
        prefs.putFloat(MARGIN_TOP, this.getMarginTop());
        prefs.putFloat(MARGIN_RIGHT, this.getMarginRight());
        prefs.putFloat(MARGIN_BOTTOM, this.getMarginBottom());
        prefs.putFloat(HORIZONTAL_SPACING, this.getHorizontalSpacing());
        prefs.putFloat(VERTICAL_SPACING, this.getVerticalSpacing());
        logger.info("Saved configuration for \"" + (this.displayName != null ? this.displayName : this.name) + "\"");
    }

    public PageConfiguration duplicate() {
        PageConfiguration config = new PageConfiguration(this.getName());
        config.setDisplayName(this.getDisplayName());
        config.setHeight(this.getHeight());
        config.setWidth(this.getWidth());
        config.setHorizontalSpacing(this.getHorizontalSpacing());
        config.setVerticalSpacing(this.getVerticalSpacing());
        config.setMarginBottom(this.getMarginBottom());
        config.setMarginLeft(this.getMarginLeft());
        config.setMarginRight(this.getMarginRight());
        config.setMarginTop(this.getMarginTop());
        return config;
    }

    public PageConfiguration(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.name : this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public float getWidth() {
        return this.width;
    }

    public float getUsableWidth() {
        return this.width - this.marginLeft - this.marginRight;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(float marginLeft) {
        this.marginLeft = marginLeft;
    }

    public Set<String> getSkipTerms() {
        return this.skipTerms;
    }

    public void parseSkipTerms(String text) {
        this.skipTerms.clear();
        if (text != null && !text.isEmpty()) {
            this.skipTerms.addAll(Arrays.asList(text.split(" ")));
        }
    }

    public float getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(float marginTop) {
        this.marginTop = marginTop;
    }

    public float getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(float marginBottom) {
        this.marginBottom = marginBottom;
    }

    public float getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(float marginRight) {
        this.marginRight = marginRight;
    }

    public float getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(float verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
    }

    public float getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(float horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
    }
}

