/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.htmlparser.msword;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.htmlparser.Node;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.javad.pdf.Page;
import org.javad.pdf.PageTitle;
import org.javad.pdf.util.PdfUtil;
import org.javad.stamp.htmlparser.HtmlHelper;
import org.javad.stamp.htmlparser.msword.AbstractProcessor;
import org.javad.stamp.htmlparser.msword.StampSetProcessor;
import org.javad.stamp.htmlparser.msword.matchers.TextNodeMatcher;
import org.javad.stamp.htmlparser.msword.styles.ComponentType;
import org.javad.stamp.htmlparser.msword.styles.MatcherFactory;
import org.javad.stamp.htmlparser.msword.styles.PageStyle;
import org.javad.stamp.pdf.StampSet;

public class PageProcessor
extends AbstractProcessor<Page> {
    private MatcherFactory factory;
    private static final Logger logger = Logger.getLogger(PageProcessor.class.getName());

    public PageProcessor(PageStyle style) {
        super(style);
        this.factory = MatcherFactory.getInstance(style);
    }

    @Override
    public Page process(Node pageNode, Node notUsed) {
        Page page = new Page();
        try {
            page.setTitle(this.processPageTitle(pageNode));
            NodeList stampSets = this.getNodeListProcessor().findChildren(pageNode.getChildren(), this.factory.getMatcher(ComponentType.StampSet));
            if (stampSets.size() > 0) {
                StampSetProcessor stampSetProcessor = new StampSetProcessor(this.getPageStyle());
                for (int i = 0; i < stampSets.size(); ++i) {
                    StampSet set = stampSetProcessor.process(stampSets.elementAt(i), pageNode);
                    if (set == null) continue;
                    page.addContent(set);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return page;
    }

    private PageTitle processPageTitle(Node pageNode) {
        PageTitle title = new PageTitle(null);
        try {
            NodeList classifiers;
            TextNodeMatcher textMatcher = new TextNodeMatcher();
            NodeList titles = this.getNodeListProcessor().findChildren(pageNode.getChildren(), this.factory.getMatcher(ComponentType.Title));
            if (titles.size() > 0) {
                if (titles.size() > 1) {
                    for (int i = 0; i < titles.size(); ++i) {
                        Node n = titles.elementAt(i);
                        NodeList textNodes = this.getNodeListProcessor().findChildren(titles, textMatcher);
                        String text = textNodes.elementAt(0).getText();
                        logger.warning("Unexpected title: " + text);
                    }
                    logger.warning("Was not expecting more than one title per page");
                }
                NodeList textNodes = this.getNodeListProcessor().findChildren(titles, textMatcher);
                String text = textNodes.elementAt(0).getText();
                text = PdfUtil.convertToProperCase(HtmlHelper.normalizeTitle(text));
                title.setTitle(text);
            }
            if ((classifiers = this.getNodeListProcessor().findChildren(pageNode.getChildren(), this.factory.getMatcher(ComponentType.Classifier))).size() > 0) {
                NodeList textNodes = this.getNodeListProcessor().findChildren(classifiers, textMatcher);
                String text = textNodes.elementAt(0).getText();
                text = PdfUtil.convertToProperCase(HtmlHelper.normalizeTitle(text));
                title.setClassifier(text);
            }
        }
        catch (ParserException ex) {
            Logger.getLogger(PageProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return title;
    }
}

