/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.htmlparser.msword.styles;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.javad.stamp.htmlparser.msword.matchers.NodeMatcher;
import org.javad.stamp.htmlparser.msword.styles.ComponentType;
import org.javad.stamp.htmlparser.msword.styles.PageStyle;

public class MatcherFactory {
    private static Map<PageStyle, MatcherFactory> factories = new HashMap<PageStyle, MatcherFactory>();
    private static final Logger logger = Logger.getLogger(MatcherFactory.class.getName());
    public static final Pattern NUMBERS = Pattern.compile("^([-+]?[0-9]*\\.?[0-9]*)+");
    private final Map<ComponentType, NodeMatcher> matchers = new HashMap<ComponentType, NodeMatcher>();

    public static MatcherFactory getInstance(PageStyle style) {
        MatcherFactory factory = factories.get(style);
        if (factory == null) {
            factory = new MatcherFactory();
            factory.initialize(style);
            factories.put(style, factory);
        }
        return factory;
    }

    private void initialize(PageStyle style) {
        Properties props = new Properties();
        try {
            props.loadFromXML(this.getClass().getResourceAsStream("/META-INF/html-legacy-parsers.xml"));
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                try {
                    Class<?> clazz = Class.forName(entry.getValue().toString());
                    if (clazz == null || !NodeMatcher.class.isAssignableFrom(clazz)) continue;
                    this.matchers.put(ComponentType.valueOf(entry.getKey().toString()), (NodeMatcher)clazz.newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An error occured configuring the XML parsers", e);
        }
    }

    public NodeMatcher getMatcher(ComponentType style) {
        return this.matchers.get((Object)style);
    }
}

