/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf;

import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfContentByte;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.javad.pdf.ISetContent;
import org.javad.pdf.OutputBounds;
import org.javad.pdf.PositionalContent;
import org.javad.pdf.SpacingMode;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.fonts.PdfFontDefinition;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.util.PdfUtil;
import org.javad.stamp.pdf.StampSet;

public class ColumnSet
extends PositionalContent
implements ISetContent {
    private float box_spacing = 4.0f;
    private SpacingMode spacingMode = SpacingMode.high;
    private String issue;
    private List<StampSet> columns = new ArrayList<StampSet>();

    public ColumnSet(PageConfiguration configuration) {
        super(configuration);
        this.box_spacing = configuration.getHorizontalSpacing();
    }

    public String getIssue() {
        return this.issue;
    }

    public void setIssue(String issue) {
        this.issue = issue;
    }

    public void addStampSet(StampSet set) {
        this.columns.add(set);
    }

    @Override
    public boolean isTextOnly() {
        return this.columns.isEmpty();
    }

    public void setSpacingMode(SpacingMode mode) {
        this.spacingMode = mode;
    }

    public SpacingMode getSpacingMode() {
        return this.spacingMode;
    }

    @Override
    public OutputBounds generate(PdfContentByte content) {
        if (this.isSkipped()) {
            return new OutputBounds(this.getX(), this.getY(), 0.0f, 0.0f);
        }
        float totalWidth = 0.0f;
        float maxHeight = 0.0f;
        float cur_x = this.getX();
        float top = this.getY();
        if (this.getIssue() != null && !this.getIssue().isEmpty()) {
            top -= PdfUtil.convertFromMillimeters(5.0f);
            Font f = FontRegistry.getInstance().getFont(PdfFontDefinition.SetIssue);
            content.setFontAndSize(f.getBaseFont(), f.getSize());
            String is = this.getIssue().replace("\\n", "\n");
            StringTokenizer tokenizer = new StringTokenizer(is, "\n", true);
            float x = PdfUtil.convertFromMillimeters(this.configuration.getUsableWidth() / 2.0f + this.configuration.getMarginLeft());
            while (tokenizer.hasMoreTokens()) {
                is = tokenizer.nextToken();
                if (is.equals("\n")) {
                    top -= f.getCalculatedSize() + 2.0f;
                    continue;
                }
                PdfUtil.renderConstrainedText(content, is, f, x, top, (int)PdfUtil.convertFromMillimeters(this.configuration.getUsableWidth()));
                if (!tokenizer.hasMoreTokens()) continue;
                top -= f.getCalculatedSize() + 2.0f;
            }
            top -= PdfUtil.convertFromMillimeters(3.0f);
        }
        float spacing = PdfUtil.convertFromMillimeters(this.getSpacingMode().getSpacing(this.box_spacing));
        int count = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            StampSet set = this.columns.get(i);
            if (set.isSkipped()) continue;
            float s_w = PdfUtil.findMaximumWidth(set, content);
            set.setX(cur_x + s_w / 2.0f);
            set.setY(top);
            OutputBounds rect = set.generate(content);
            totalWidth += rect.width + (count > 0 ? spacing : 0.0f);
            cur_x += rect.width + spacing;
            maxHeight = Math.max(maxHeight, rect.height);
            ++count;
        }
        return new OutputBounds(this.getX() - totalWidth / 2.0f, this.getY(), totalWidth, maxHeight + (this.getY() - top));
    }

    @Override
    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("column-set");
        for (StampSet row : this.columns) {
            row.writeToXml(writer);
        }
        writer.writeEndElement();
        writer.flush();
    }
}

