/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfContentByte;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.javad.pdf.ISetContent;
import org.javad.pdf.OutputBounds;
import org.javad.pdf.PositionalContent;
import org.javad.pdf.SpacingMode;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.fonts.PdfFontDefinition;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.util.PdfUtil;
import org.javad.stamp.pdf.StampRow;

public class CompositeRow
extends PositionalContent
implements ISetContent {
    private String description;
    private float box_spacing = 4.0f;
    private SpacingMode spacingMode = SpacingMode.high;
    List<StampRow> rows = new ArrayList<StampRow>();

    public CompositeRow(PageConfiguration configuration) {
        super(configuration);
        this.box_spacing = configuration.getHorizontalSpacing();
    }

    @Override
    public boolean isTextOnly() {
        return this.rows.isEmpty();
    }

    public void setSpacingMode(SpacingMode mode) {
        this.spacingMode = mode;
    }

    public SpacingMode getSpacingMode() {
        return this.spacingMode;
    }

    public void addStampRow(StampRow row) {
        this.rows.add(row);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String rowText) {
        this.description = rowText.replace("\\n", "\n");
    }

    @Override
    public OutputBounds generate(PdfContentByte content) {
        if (this.isSkipped()) {
            return new OutputBounds(this.getX(), this.getY(), 0.0f, 0.0f);
        }
        float maxHeight = 0.0f;
        float maxWidth = 0.0f;
        float top = this.getY();
        if (this.getDescription() != null && !this.getDescription().isEmpty()) {
            content.setColorStroke(BaseColor.BLACK);
            Font descFont = FontRegistry.getInstance().getFont(PdfFontDefinition.CompositeSetDescription);
            content.setFontAndSize(descFont.getBaseFont(), descFont.getSize());
            top -= descFont.getCalculatedSize();
            int count = 0;
            int tc = this.getDescription().split("\n").length;
            for (String desc : this.getDescription().split("\n")) {
                maxWidth = Math.max(maxWidth, content.getEffectiveStringWidth(desc, false));
                PdfUtil.renderConstrainedText(content, desc, descFont, this.getX(), top, (int)maxWidth);
                top -= descFont.getCalculatedSize() + (float)(++count < tc ? 2 : 4);
            }
        }
        float totalWidth = 0.0f;
        float totalHeight = this.getY() - top;
        float spacing = PdfUtil.convertFromMillimeters(this.getSpacingMode().getSpacing(this.box_spacing));
        int count = 0;
        for (int i = 0; i < this.rows.size(); ++i) {
            StampRow set = this.rows.get(i);
            if (set.isSkipped()) continue;
            totalWidth += PdfUtil.findMaximumWidth(set, content) + (count > 0 ? spacing : 0.0f);
            ++count;
        }
        float cur_x = this.getX() - totalWidth / 2.0f;
        count = 0;
        for (StampRow set : this.rows) {
            if (set.isSkipped()) continue;
            set.setX(cur_x + PdfUtil.findMaximumWidth(set, content) / 2.0f);
            set.setY(top);
            OutputBounds rect = set.generate(content);
            cur_x += rect.width + (++count > 0 ? spacing : 0.0f);
            maxHeight = Math.max(maxHeight, rect.height);
        }
        maxWidth = Math.max(maxWidth, totalWidth);
        return new OutputBounds(this.getX() - maxWidth / 2.0f, this.getY(), maxWidth, totalHeight += maxHeight);
    }

    @Override
    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

