/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfContentByte;
import java.awt.Color;
import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.javad.pdf.OutputBounds;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.fonts.PdfFontDefinition;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.util.PdfUtil;
import org.javad.stamp.pdf.AbstractStampContent;
import org.javad.xml.XMLSerializable;

public class StampBox
extends AbstractStampContent
implements XMLSerializable {
    private static final Logger logger = Logger.getLogger(StampBox.class.getName());
    private static final int TEXT_GAP = 5;
    private String denomination;
    private String description;
    private String descriptionSecondary;
    private String catalogueNumber;
    private Image image;
    private boolean imageOnly = false;
    private boolean border = true;
    private SetTenantPosition setTenantPosition = null;
    private Bisect bisect = Bisect.none;
    private Shape shape = Shape.rectangle;
    private float textPadding = 0.0f;

    public StampBox(PageConfiguration configuration) {
        super(configuration);
    }

    public boolean isImageOnly() {
        return this.imageOnly;
    }

    public void setImageOnly(boolean imgOnly) {
        this.imageOnly = imgOnly;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public void setSetTenantPosition(SetTenantPosition position) {
        this.setTenantPosition = position;
    }

    public SetTenantPosition getSetTenantPosition() {
        return this.setTenantPosition;
    }

    public String getDenomination() {
        return this.denomination;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public float getTextPadding() {
        return this.textPadding;
    }

    public void setTextPadding(float padding) {
        this.textPadding = padding;
    }

    public Bisect getBisect() {
        return this.bisect;
    }

    public void setBisect(Bisect b) {
        this.bisect = b;
    }

    public void setDenomination(String denomination) {
        this.denomination = denomination;
    }

    public void setImage(Image img) {
        this.image = img;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescriptionSecondary() {
        return this.descriptionSecondary;
    }

    public void setDescriptionSecondary(String descriptionSecondary) {
        this.descriptionSecondary = descriptionSecondary;
    }

    public String getCatalogueNumber() {
        return this.catalogueNumber;
    }

    public void setCatalogueNumber(String catalogueNumber) {
        this.catalogueNumber = catalogueNumber;
    }

    @Override
    public OutputBounds generate(PdfContentByte content) {
        if (this.isSkipped()) {
            return new OutputBounds(this.getX(), this.getY(), 0.0f, 0.0f);
        }
        OutputBounds rect = new OutputBounds(this.getX(), this.getY(), PdfUtil.convertFromMillimeters(this.getWidth() + this.getPadding()), PdfUtil.convertFromMillimeters(this.getHeight() + this.getVerticalPadding()));
        if (this.bisect != Bisect.none && this.isBorder()) {
            this.drawBisect(content, rect);
        }
        if (this.getSetTenantPosition() == null) {
            this.drawShape(content, rect);
        }
        float verticalPadding = PdfUtil.convertFromMillimeters(this.getVerticalPadding());
        float w = rect.width;
        Font f = FontRegistry.getInstance().getFont(PdfFontDefinition.Stampbox);
        Font f2 = FontRegistry.getInstance().getFont(PdfFontDefinition.StampboxOther);
        float center = this.getX() + w / 2.0f;
        int totalRows = PdfUtil.getDescriptionTextRowsForStampBox(content, f, f2, this.getDescription(), this.getDescriptionSecondary(), this.getWidth());
        totalRows = Math.max(totalRows, 3);
        float top = this.getY() + verticalPadding + f.getCalculatedSize() * (float)(totalRows + 3) + PdfUtil.convertFromMillimeters(this.getTextPadding());
        if (this.image != null) {
            try {
                com.itextpdf.text.Image img = this.determineScaledImage(rect, f.getCalculatedSize(), top, this.isImageOnly());
                if (img != null) {
                    content.addImage(img);
                }
            }
            catch (Exception e) {
                logger.log(Level.FINER, "An error occured scaling the image. ", e);
            }
        }
        if (!this.isImageOnly()) {
            if (this.shape == Shape.diamond || this.shape == Shape.triangleInverted) {
                top = this.getY() + rect.height / 2.0f + f.getCalculatedSize() * 1.5f;
            }
            top += PdfUtil.renderConstrainedText(content, this.getDenomination(), f, center, top, this.getWidth());
            float d_delta = PdfUtil.renderConstrainedText(content, this.getDescription(), f, center, top -= f.getCalculatedSize() + 1.0f, this.getWidth());
            float rows = (float)Math.ceil(d_delta / f.getCalculatedSize());
            top += d_delta;
            float delta = PdfUtil.renderConstrainedText(content, this.getDescriptionSecondary(), f2, center, top, this.getWidth());
            if (delta < 1.0f && (double)rows > -3.0) {
                delta = -1.0f * (f.getSize() + 1.0f);
            }
            if (totalRows <= 3 && d_delta >= -1.0f * (f.getSize() + 1.0f)) {
                top -= (float)Math.max(1, totalRows - 3) * (f.getSize() + 1.0f);
            } else if (totalRows > 3 && d_delta >= -1.0f * (f.getSize() + 1.0f)) {
                top -= (f.getSize() + 1.0f) * (float)(totalRows + 1 - 3) - (float)(totalRows - 3);
            } else if (totalRows > 3) {
                top -= (f.getSize() + 1.0f) * (float)(totalRows - 3) - (float)(totalRows - 3);
                delta = 0.0f;
            }
            PdfUtil.renderConstrainedText(content, this.getCatalogueNumber(), f, center, top += delta, this.getWidth());
        }
        return rect;
    }

    void drawShape(PdfContentByte content, OutputBounds rect) {
        content.setColorFill(BaseColor.WHITE);
        this.drawPath(content, rect);
        content.fill();
        if (this.isBorder()) {
            content.setColorStroke(BaseColor.BLACK);
            content.setLineWidth(0.8f);
            this.drawPath(content, rect);
            content.stroke();
        }
        content.setColorFill(BaseColor.BLACK);
    }

    private void drawPath(PdfContentByte content, OutputBounds rect) {
        switch (this.shape) {
            case rectangle: {
                content.rectangle(rect.x, rect.y, rect.width, rect.height);
                break;
            }
            case triangle: {
                content.moveTo(rect.x, rect.y);
                content.lineTo(rect.x + rect.width, rect.y);
                content.lineTo(rect.x + rect.width / 2.0f, rect.y + rect.height);
                content.lineTo(rect.x, rect.y);
                break;
            }
            case triangleInverted: {
                content.moveTo(rect.x + rect.width / 2.0f, rect.y);
                content.lineTo(rect.x + rect.width, rect.y + rect.height);
                content.lineTo(rect.x, rect.y + rect.height);
                content.lineTo(rect.x + rect.width / 2.0f, rect.y);
                break;
            }
            case diamond: {
                content.moveTo(rect.x, rect.y + rect.height / 2.0f);
                content.lineTo(rect.x + rect.width / 2.0f, rect.y);
                content.lineTo(rect.x + rect.width, rect.y + rect.height / 2.0f);
                content.lineTo(rect.x + rect.width / 2.0f, rect.y + rect.height);
                content.lineTo(rect.x, rect.y + rect.height / 2.0f);
            }
        }
    }

    void drawBisect(PdfContentByte content, OutputBounds rect) {
        content.setLineWidth(0.5f);
        content.setColorStroke(BaseColor.GRAY);
        float dx1 = 0.0f;
        float dx2 = 0.0f;
        float dy1 = 0.0f;
        float dy2 = 0.0f;
        float xp = (int)PdfUtil.convertFromMillimeters(this.getPadding() + 2);
        float yp = (int)PdfUtil.convertFromMillimeters(this.getVerticalPadding() + 2);
        switch (this.bisect) {
            case top_left: {
                dx1 = xp;
                dy1 = rect.height - yp;
                dx2 = rect.width - xp;
                dy2 = yp;
                break;
            }
            case top_right: {
                dx1 = xp;
                dy1 = yp;
                dx2 = rect.width - xp;
                dy2 = rect.height - yp;
                break;
            }
            case vertical: {
                dx1 = rect.width / 2.0f;
                dy1 = yp;
                dx2 = dx1;
                dy2 = rect.height - yp;
            }
        }
        content.moveTo(rect.x + dx1, rect.y + dy1);
        content.setLineDash(5.0f, 2.0f, 0.0f);
        content.lineTo(rect.x + dx2, rect.y + dy2);
        content.stroke();
        content.setLineDash(1.0f, 0.0f, 0.0f);
    }

    protected com.itextpdf.text.Image determineScaledImage(OutputBounds rect, float fontSize, float top, boolean onlyImage) throws Exception {
        com.itextpdf.text.Image img = com.itextpdf.text.Image.getInstance(this.image, Color.BLACK);
        float vGap = rect.y + rect.height - (onlyImage ? 0.0f : top + fontSize + 5.0f);
        float hGap = rect.width;
        float vRatio = img.getHeight() * 1.4f / vGap;
        float hRatio = img.getWidth() * 1.2f / hGap;
        float ratio = Math.max(1.0f, Math.max(vRatio, hRatio));
        img.scaleAbsolute(img.getWidth() / ratio, img.getHeight() / ratio);
        float deltaH = rect.getHeight() - img.getScaledHeight();
        img.setAbsolutePosition(rect.getX() + (rect.getWidth() - img.getWidth() / ratio) / 2.0f, !onlyImage ? top + fontSize + 5.0f : rect.y + deltaH / 2.0f);
        return img;
    }

    @Override
    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("s");
        StringBuilder buf = new StringBuilder();
        buf.append("\"").append(this.width).append(" ").append(this.height).append("\" \"" + (this.denomination != null ? this.denomination : "") + "\" \"");
        buf.append(this.description != null ? this.description : "").append("\" \"");
        buf.append(this.descriptionSecondary != null ? this.descriptionSecondary : "").append("\" \"");
        buf.append((this.catalogueNumber != null ? this.catalogueNumber : "") + "\"");
        writer.writeCharacters(buf.toString());
        writer.writeEndElement();
        writer.flush();
    }

    public static enum SetTenantPosition {
        first,
        middle,
        last;

    }

    public static enum Bisect {
        none,
        vertical,
        top_left,
        top_right;

    }

    public static enum Shape {
        rectangle,
        triangle,
        triangleInverted,
        diamond;

    }
}

