/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfContentByte;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.javad.pdf.ISetContent;
import org.javad.pdf.OutputBounds;
import org.javad.pdf.PositionalContent;
import org.javad.pdf.VerticalAlignment;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.fonts.PdfFontDefinition;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.util.PdfUtil;
import org.javad.stamp.pdf.IStampContent;

public class StampRow
extends PositionalContent
implements ISetContent {
    String description;
    List<IStampContent> stampContents = new ArrayList<IStampContent>();
    VerticalAlignment valign = VerticalAlignment.top;
    private float padding;

    public StampRow(PageConfiguration configuration) {
        super(configuration);
        this.padding = configuration.getHorizontalSpacing();
    }

    @Override
    public boolean isTextOnly() {
        return this.stampContents.isEmpty();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String rowText) {
        this.description = rowText.replace("\\n", "\n");
    }

    public float getHorizontalPadding() {
        return this.padding;
    }

    public void setHorizontalPadding(float padding) {
        this.padding = padding;
    }

    public VerticalAlignment getValign() {
        return this.valign;
    }

    public void setValign(VerticalAlignment valign) {
        this.valign = valign;
    }

    public void addStampContent(IStampContent box) {
        this.stampContents.add(box);
    }

    public int size() {
        return this.stampContents.size();
    }

    public List<IStampContent> getStampContent() {
        return this.stampContents;
    }

    @Override
    public OutputBounds generate(PdfContentByte content) {
        float totalHeight;
        float start_x;
        if (this.isSkipped()) {
            return new OutputBounds(this.getX(), this.getY(), 0.0f, 0.0f);
        }
        float maxWidth = 0.0f;
        float top = this.getY();
        if (this.getDescription() != null && !this.getDescription().isEmpty()) {
            content.setColorStroke(BaseColor.BLACK);
            Font descFont = FontRegistry.getInstance().getFont(PdfFontDefinition.RowDescription);
            content.setFontAndSize(descFont.getBaseFont(), descFont.getSize());
            top -= descFont.getCalculatedSize();
            int count = 0;
            String[] _description = this.getDescription().split("\n");
            int tc = _description.length;
            for (String desc : _description) {
                maxWidth = Math.max(maxWidth, (float)((int)descFont.getBaseFont().getWidthPoint(desc, descFont.getSize())));
                PdfUtil.renderConstrainedText(content, desc, descFont, this.getX(), top, (int)((double)maxWidth * 1.1));
                top -= descFont.getCalculatedSize() + (float)(++count < tc ? 2 : 4);
            }
        }
        float totalWidth = 0.0f;
        int maxHeight = 0;
        int count = 0;
        for (int i = 0; i < this.stampContents.size(); ++i) {
            if (this.stampContents.get(i).isSkipped()) continue;
            totalWidth += (float)(this.stampContents.get(i).getWidth() + this.stampContents.get(i).getPadding());
            if (count > 0) {
                totalWidth += this.padding;
            }
            ++count;
            maxHeight = Math.max(maxHeight, this.stampContents.get(i).getHeight());
        }
        totalWidth = PdfUtil.convertFromMillimeters(totalWidth);
        float cur_x = start_x = this.getX() - totalWidth / 2.0f;
        float deltaHeight = totalHeight = this.getY() - top;
        count = 0;
        for (IStampContent s : this.stampContents) {
            if (s.isSkipped()) continue;
            if (count > 0) {
                cur_x += PdfUtil.convertFromMillimeters(this.padding);
            }
            s.setX(cur_x);
            int delta_y = this.getVerticalAlignmentOffset(s, maxHeight);
            s.setY(top - PdfUtil.convertFromMillimeters(delta_y));
            OutputBounds r = s.generate(content);
            totalHeight = Math.max(r.height + deltaHeight, totalHeight);
            cur_x += r.width;
            ++count;
        }
        maxWidth = (int)Math.max(maxWidth, totalWidth);
        return new OutputBounds(start_x, this.getY(), maxWidth, totalHeight);
    }

    protected int getVerticalAlignmentOffset(IStampContent s, int maxHeight) {
        int delta_y = 0;
        switch (this.valign) {
            case top: {
                delta_y = s.getHeight() + s.getVerticalPadding();
                break;
            }
            case middle: {
                delta_y = s.getHeight() + s.getVerticalPadding() + (maxHeight - s.getHeight()) / 2;
                break;
            }
            case bottom: {
                delta_y = maxHeight + s.getVerticalPadding();
            }
        }
        return delta_y;
    }

    @Override
    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("row-set");
        if (this.description != null) {
            writer.writeAttribute("description", this.description);
        }
        if (this.valign != VerticalAlignment.top) {
            writer.writeAttribute("valign", this.valign.toString());
        }
        for (IStampContent row : this.stampContents) {
            row.writeToXml(writer);
        }
        writer.writeEndElement();
        writer.flush();
    }
}

