/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfContentByte;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.javad.pdf.ISetContent;
import org.javad.pdf.OutputBounds;
import org.javad.pdf.PositionalContent;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.fonts.PdfFontDefinition;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.util.PdfUtil;

public class StampSet
extends PositionalContent
implements ISetContent {
    private String issue;
    private String description;
    private String descriptionSecondary;
    private String comment;
    List<ISetContent> rows = new ArrayList<ISetContent>();
    private float verticalPadding = 4.0f;

    public StampSet(PageConfiguration configuration) {
        super(configuration);
        this.verticalPadding = configuration.getVerticalSpacing();
    }

    @Override
    public boolean isTextOnly() {
        return this.rows.isEmpty();
    }

    public String getIssue() {
        return this.issue;
    }

    public void setIssue(String issue) {
        this.issue = issue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description != null ? description.replace("\\n", "\n") : null;
    }

    public String getDescriptionSecondary() {
        return this.descriptionSecondary;
    }

    public void setDescriptionSecondary(String descriptionSecondary) {
        this.descriptionSecondary = descriptionSecondary != null ? descriptionSecondary.replace("\\n", "\n") : null;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment != null ? comment.replace("\\n", "\n") : null;
    }

    public void addContentRow(ISetContent row) {
        this.rows.add(row);
    }

    public List<ISetContent> getContentRows() {
        return this.rows;
    }

    @Override
    public OutputBounds generate(PdfContentByte content) {
        if (this.isSkipped()) {
            return new OutputBounds(this.getX(), this.getY(), 0.0f, 0.0f);
        }
        float maxWidth = 0.0f;
        content.setColorStroke(BaseColor.BLACK);
        float top = this.getY();
        if (this.getIssue() != null && !this.getIssue().isEmpty()) {
            top -= PdfUtil.convertFromMillimeters(5.0f);
            Font f = FontRegistry.getInstance().getFont(PdfFontDefinition.SetIssue);
            content.setFontAndSize(f.getBaseFont(), f.getSize());
            String is = this.getIssue().replace("\\n", "\n");
            StringTokenizer tokenizer = new StringTokenizer(is, "\n", true);
            while (tokenizer.hasMoreTokens()) {
                is = tokenizer.nextToken();
                maxWidth = Math.max(maxWidth, content.getEffectiveStringWidth(is, false));
                if (is.equals("\n")) {
                    top -= f.getCalculatedSize() + 2.0f;
                    continue;
                }
                PdfUtil.renderConstrainedText(content, is, f, this.getX(), top, (int)maxWidth);
                if (!tokenizer.hasMoreTokens()) continue;
                top -= f.getCalculatedSize() + 2.0f;
            }
            top -= PdfUtil.convertFromMillimeters(3.0f);
        }
        if (this.getDescription() != null && !this.getDescription().isEmpty()) {
            Font descFont = FontRegistry.getInstance().getFont(PdfFontDefinition.SetDescription);
            content.setFontAndSize(descFont.getBaseFont(), descFont.getSize());
            top -= descFont.getCalculatedSize();
            int count = 0;
            int tc = this.getDescription().split("\n").length;
            for (String desc : this.getDescription().split("\n")) {
                maxWidth = Math.max(maxWidth, content.getEffectiveStringWidth(desc, false));
                PdfUtil.renderConstrainedText(content, desc, descFont, this.getX(), top, (int)maxWidth);
                if (++count >= tc) continue;
                top -= descFont.getCalculatedSize() + 2.0f;
            }
        }
        if (this.getDescriptionSecondary() != null && !this.getDescriptionSecondary().isEmpty()) {
            Font secFont = FontRegistry.getInstance().getFont(PdfFontDefinition.SetDescriptionSecondary);
            content.setFontAndSize(secFont.getBaseFont(), secFont.getSize());
            top -= secFont.getCalculatedSize() + PdfUtil.convertFromMillimeters(3.0f);
            int count = 0;
            int tc = this.getDescriptionSecondary().split("\n").length;
            for (String desc : this.getDescriptionSecondary().split("\n")) {
                maxWidth = Math.max(maxWidth, content.getEffectiveStringWidth(desc, false));
                PdfUtil.renderConstrainedText(content, desc, secFont, this.getX(), top, (int)maxWidth);
                if (++count >= tc) continue;
                top -= secFont.getCalculatedSize() + 2.0f;
            }
        }
        if (!this.rows.isEmpty()) {
            top -= top != this.getY() ? PdfUtil.convertFromMillimeters(3.0f) : 0.0f;
            int count = 0;
            for (int i = 0; i < this.rows.size(); ++i) {
                ISetContent row = this.rows.get(i);
                if (row.isSkipped()) continue;
                float f = count > 0 ? PdfUtil.convertFromMillimeters(this.verticalPadding) : 0.0f;
                row.setX(this.getX());
                row.setY(top -= f);
                OutputBounds bounds = row.generate(content);
                ++count;
                top -= bounds.height;
                maxWidth = Math.max(maxWidth, bounds.width);
            }
        }
        if (this.getComment() != null && !this.getComment().isEmpty()) {
            top -= PdfUtil.convertFromMillimeters((int)(0.75 * (double)this.verticalPadding));
            Font cFont = FontRegistry.getInstance().getFont(PdfFontDefinition.SetComment);
            content.setFontAndSize(cFont.getBaseFont(), cFont.getSize());
            for (String s : this.getComment().split("\n")) {
                maxWidth = Math.max(maxWidth, content.getEffectiveStringWidth(s, false));
                PdfUtil.renderConstrainedText(content, s, cFont, this.getX(), top -= cFont.getCalculatedSize(), (int)maxWidth);
            }
        }
        OutputBounds rect = new OutputBounds(this.getX() - maxWidth / 2.0f, this.getY(), maxWidth, this.getY() - top);
        return rect;
    }

    @Override
    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("set");
        if (this.issue != null) {
            writer.writeAttribute("issue", this.issue);
        }
        if (this.description != null) {
            writer.writeAttribute("description", this.description);
        }
        if (this.descriptionSecondary != null) {
            writer.writeAttribute("description-secondary", this.descriptionSecondary);
        }
        if (this.comment != null) {
            writer.writeAttribute("comment", this.comment);
        }
        for (ISetContent row : this.rows) {
            row.writeToXml(writer);
        }
        writer.writeEndElement();
        writer.flush();
    }
}

