/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf.ui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.javad.events.StatusEvent;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.model.PageConfigurations;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.events.PdfAppEvent;
import org.javad.stamp.pdf.ui.ConfigurationRenderer;
import org.javad.stamp.pdf.ui.model.GenerateBean;
import pub.domain.GradientPanel;

public class AlbumGeneratorPanel
extends GradientPanel
implements PageConfigurations.PageConfigurationChangeHandler {
    private String default_folder = null;
    private String default_output_folder = null;
    private JLabel inputFileLabel;
    private JTextField inputFileText;
    private JButton btnInputFile;
    private JLabel outputFolderLabel;
    private JTextField outputFolderText;
    private JButton btnOutputFolder;
    private JLabel tagLabel;
    private JTextField tagText;
    private JFileChooser fileChooser;
    private JFileChooser folderChooser;
    private JButton btnGenerate;
    private JButton btnOpenPdf;
    private JCheckBox checkRenderBorders;
    private GenerateBean modelBean = null;
    private static final Logger logger = Logger.getLogger(AlbumGeneratorPanel.class.getName());
    private JPanel panel;
    private JLabel configurationLabel;
    private JComboBox configurationComboBox;
    private JTextArea logText;
    private JLabel logLabel;
    private JScrollPane scrollPane;
    private JPanel configPanel;
    private JButton btnDeleteConfiguration;
    private JCheckBox checkRenderReverse;

    public AlbumGeneratorPanel() {
        this.initialize();
    }

    public GenerateBean getModelBean() {
        return this.modelBean;
    }

    public void setModelBean(GenerateBean modelBean) {
        this.modelBean = modelBean;
    }

    private void initialize() {
        AnnotationProcessor.process((Object)this);
        this.setModelBean(new GenerateBean());
        this.setBackground(new Color(248, 248, 255));
        this.setForeground(new Color(211, 211, 211));
        this.setDirection(0);
        this.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, ColumnSpec.decode("79px"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.bounded(Sizes.PREFERRED, Sizes.constant("250dlu", true), Sizes.constant("400dlu", true)), 1.0), ColumnSpec.decode("left:40px"), FormFactory.UNRELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("22dlu"), FormFactory.UNRELATED_GAP_ROWSPEC, RowSpec.decode("24px"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("24px"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("fill:60px:grow"), FormFactory.UNRELATED_GAP_ROWSPEC}));
        this.add(this.getConfigurationLabel(), "2, 2, right, default");
        this.add(this.getConfigPanel(), "4, 2, 2, 1, left, fill");
        this.add(this.getInputFileLabel(), "2, 4, fill, center");
        this.add(this.getInputFileText(), "4, 4, fill, center");
        this.add(this.getBtnInputFile(), "5, 4, left, top");
        this.add(this.getOutputFolderLabel(), "2, 6, fill, fill");
        this.add(this.getOutputFolderText(), "4, 6, fill, center");
        this.add(this.getBtnOutputFolder(), "5, 6, left, top");
        this.add(this.getTagLabel(), "2, 8, fill, center");
        this.add(this.getTagText(), "4, 8, fill, center");
        this.add(this.getCheckRenderBorders(), "4, 10");
        this.add(this.getCheckRenderReverse(), "4, 12, left, default");
        this.add(this.getPanel(), "4, 14,fill, top");
        this.add(this.getLogLabel(), "2, 16, right, top");
        this.add(this.getScrollPane(), "4, 16,2,1 fill, fill");
        Preferences prefs = Resources.getPreferencesNode();
        String folderOutput = prefs.get("default-output-folder", null);
        String inputFile = prefs.get("default-input-file", null);
        if (folderOutput != null) {
            this.getOutputFolderText().setText(folderOutput);
        }
        if (inputFile != null) {
            this.getInputFileText().setText(inputFile);
        }
        Logger.getLogger("org.javad").setLevel(Level.INFO);
        Logger.getLogger("org.javad").addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                AlbumGeneratorPanel.this.getLogText().append(record.getMessage() + "\n");
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
                AlbumGeneratorPanel.this.getLogText().setText(null);
            }
        });
        this.loadConfigurations();
        PageConfigurations configs = PageConfigurations.getInstance();
        configs.addPageConfigurationChangeHandler(this);
    }

    @EventSubscriber(eventClass=PdfAppEvent.class)
    public void handleAppEvent(PdfAppEvent evt) {
        if (evt.getType() == PdfAppEvent.EventType.Generated) {
            this.getBtnOpenPdf().setEnabled(true);
        } else if (evt.getType() == PdfAppEvent.EventType.Generate_Error) {
            if (evt.getData() instanceof IOException) {
                IOException ioe = (IOException)evt.getData();
                String msg = MessageFormat.format(Resources.getString("generate.error.msg"), ioe.getLocalizedMessage());
                JOptionPane.showMessageDialog((Component)((Object)this), msg, Resources.getString("generate.error.title"), 0);
            }
            if (evt.getData() instanceof Throwable) {
                ((Throwable)evt.getData()).printStackTrace();
            }
            logger.log(Level.FINE, "Error generating the pages.", (Throwable)evt.getData());
        }
    }

    protected JLabel getInputFileLabel() {
        if (this.inputFileLabel == null) {
            this.inputFileLabel = new JLabel(Resources.getString("label.inputFile"));
            this.inputFileLabel.setHorizontalAlignment(4);
            this.inputFileLabel.setPreferredSize(new Dimension(100, 14));
        }
        return this.inputFileLabel;
    }

    protected JTextField getInputFileText() {
        if (this.inputFileText == null) {
            this.inputFileText = new JTextField();
            this.inputFileText.setMinimumSize(new Dimension(100, 20));
            this.inputFileText.setPreferredSize(new Dimension(250, 24));
            this.inputFileText.setColumns(10);
            this.inputFileText.getDocument().addDocumentListener(new FileDocumentUpdate());
        }
        return this.inputFileText;
    }

    protected JButton getBtnInputFile() {
        if (this.btnInputFile == null) {
            this.btnInputFile = new JButton();
            this.btnInputFile.setBorder(null);
            this.btnInputFile.setPreferredSize(new Dimension(40, 24));
            this.btnInputFile.setName("pagegen-inputFile");
            this.btnInputFile.setAction(new ChooseInputFile());
        }
        return this.btnInputFile;
    }

    protected JLabel getTagLabel() {
        if (this.tagLabel == null) {
            this.tagLabel = new JLabel(Resources.getString("label.tag"));
            this.tagLabel.setHorizontalAlignment(4);
            this.tagLabel.setPreferredSize(new Dimension(100, 14));
        }
        return this.tagLabel;
    }

    protected JTextField getTagText() {
        if (this.tagText == null) {
            this.tagText = new JTextField();
            this.tagText.setPreferredSize(new Dimension(150, 24));
            this.tagText.setMinimumSize(new Dimension(100, 20));
            this.tagText.setColumns(10);
        }
        return this.tagText;
    }

    protected JLabel getOutputFolderLabel() {
        if (this.outputFolderLabel == null) {
            this.outputFolderLabel = new JLabel(Resources.getString("label.outputFolder"));
            this.outputFolderLabel.setHorizontalAlignment(4);
            this.outputFolderLabel.setPreferredSize(new Dimension(100, 14));
        }
        return this.outputFolderLabel;
    }

    protected JTextField getOutputFolderText() {
        if (this.outputFolderText == null) {
            this.outputFolderText = new JTextField();
            this.outputFolderText.setPreferredSize(new Dimension(250, 24));
            this.outputFolderText.setMinimumSize(new Dimension(100, 20));
            this.outputFolderText.setColumns(10);
            this.outputFolderText.getDocument().addDocumentListener(new FileDocumentUpdate());
        }
        return this.outputFolderText;
    }

    protected JButton getBtnOutputFolder() {
        if (this.btnOutputFolder == null) {
            this.btnOutputFolder = new JButton();
            this.btnOutputFolder.setPreferredSize(new Dimension(40, 24));
            this.btnOutputFolder.setName("pagegen-outputFolder");
            this.btnOutputFolder.setAction(new ChooseOutputFolder());
        }
        return this.btnOutputFolder;
    }

    protected JButton getBtnGenerate() {
        if (this.btnGenerate == null) {
            this.btnGenerate = new JButton(Resources.getString("button.generate"));
            this.btnGenerate.setEnabled(false);
            this.btnGenerate.setPreferredSize(new Dimension(110, 25));
            this.btnGenerate.setName("pagegen-generate");
            this.btnGenerate.setAction(new GenerateAction());
        }
        return this.btnGenerate;
    }

    protected JButton getBtnOpenPdf() {
        if (this.btnOpenPdf == null) {
            this.btnOpenPdf = new JButton(Resources.getString("button.open"));
            this.btnOpenPdf.setPreferredSize(new Dimension(110, 25));
            this.btnOpenPdf.setName("pagegen-open");
            this.btnOpenPdf.setAction(new OpenPdfAction());
            this.btnOpenPdf.setEnabled(false);
        }
        return this.btnOpenPdf;
    }

    protected JCheckBox getCheckRenderBorders() {
        if (this.checkRenderBorders == null) {
            this.checkRenderBorders = new JCheckBox(Resources.getString("label.renderBorders"));
            this.checkRenderBorders.setAction(new ToggleBordersAction());
            this.checkRenderBorders.setOpaque(false);
        }
        return this.checkRenderBorders;
    }

    protected JCheckBox getCheckRenderReverse() {
        if (this.checkRenderReverse == null) {
            this.checkRenderReverse = new JCheckBox(Resources.getString("label.renderReverse"));
            this.checkRenderReverse.setAction(new ToggleReverseAction());
            this.checkRenderReverse.setOpaque(false);
        }
        return this.checkRenderReverse;
    }

    protected JFileChooser getInputFileChooser() {
        if (this.fileChooser == null) {
            File f;
            this.fileChooser = new JFileChooser();
            this.fileChooser.setName("pagegen-inputChooser");
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            this.fileChooser.setFileFilter(new InputFileFilter());
            String folder = this.default_folder;
            if (this.default_folder == null) {
                Preferences prefs = Resources.getPreferencesNode();
                folder = prefs.get("default-input-folder", null);
            }
            if (folder != null && (f = new File(folder)).exists()) {
                this.fileChooser.setCurrentDirectory(f);
            }
        }
        return this.fileChooser;
    }

    protected JFileChooser getOutputFolderChooser() {
        if (this.folderChooser == null) {
            File f;
            this.folderChooser = new JFileChooser();
            this.folderChooser.setName("pagegen-outputchooser");
            this.folderChooser.setAcceptAllFileFilterUsed(false);
            this.folderChooser.setFileSelectionMode(1);
            this.folderChooser.setFileFilter(new OutputFileFilter());
            String folder = this.default_output_folder;
            if (this.default_output_folder == null) {
                Preferences prefs = Resources.getPreferencesNode();
                folder = prefs.get("default-output-folder", null);
            }
            if (folder != null && (f = new File(folder)).exists() && f.isDirectory()) {
                this.folderChooser.setCurrentDirectory(f);
            }
        }
        return this.folderChooser;
    }

    protected JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setPreferredSize(new Dimension(10, 40));
            this.panel.setMinimumSize(new Dimension(10, 50));
            this.panel.setOpaque(false);
            this.panel.add(this.getBtnGenerate());
            this.panel.add(this.getBtnOpenPdf());
        }
        return this.panel;
    }

    protected JLabel getConfigurationLabel() {
        if (this.configurationLabel == null) {
            this.configurationLabel = new JLabel(Resources.getString("label.configuration"));
        }
        return this.configurationLabel;
    }

    protected JComboBox getConfigurationComboBox() {
        if (this.configurationComboBox == null) {
            this.configurationComboBox = new JComboBox();
            this.configurationComboBox.setMinimumSize(new Dimension(23, 22));
            this.configurationComboBox.setPreferredSize(new Dimension(250, 22));
            this.configurationComboBox.setRenderer(new ConfigurationRenderer());
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PageConfiguration configuration = (PageConfiguration)AlbumGeneratorPanel.this.configurationComboBox.getSelectedItem();
                    PageConfigurations.getInstance().setActiveConfiguration(configuration.getName());
                    AlbumGeneratorPanel.this.getBtnDeleteConfiguration().setEnabled(!configuration.isSystemConfiguration());
                }
            };
            this.configurationComboBox.addActionListener(listener);
        }
        return this.configurationComboBox;
    }

    protected void loadConfigurations() {
        PageConfigurations configs = PageConfigurations.getInstance();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(configs.getConfigurations().toArray());
        this.getConfigurationComboBox().setModel(model);
        PageConfiguration active = configs.getActiveConfiguration();
        this.getBtnDeleteConfiguration().getAction().setEnabled(!active.isSystemConfiguration());
        this.getConfigurationComboBox().setSelectedItem(active);
    }

    protected JTextArea getLogText() {
        if (this.logText == null) {
            this.logText = new JTextArea();
            this.logText.setLineWrap(true);
            this.logText.setEditable(false);
            this.logText.setText("");
        }
        return this.logText;
    }

    protected JLabel getLogLabel() {
        if (this.logLabel == null) {
            this.logLabel = new JLabel(Resources.getString("label.log"));
        }
        return this.logLabel;
    }

    protected JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setVerticalScrollBarPolicy(22);
            this.scrollPane.setViewportView(this.getLogText());
        }
        return this.scrollPane;
    }

    @Override
    public void onPageConfigurationChanged(PageConfigurations.PageConfigurationChangeType type, PageConfiguration config) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getConfigurationComboBox().getModel();
        if (type == PageConfigurations.PageConfigurationChangeType.CREATE) {
            model.addElement(config);
        } else if (type == PageConfigurations.PageConfigurationChangeType.SAVE) {
            this.getConfigurationComboBox().repaint();
        } else if (type == PageConfigurations.PageConfigurationChangeType.DELETE) {
            model.removeElement(config);
        }
    }

    protected JPanel getConfigPanel() {
        if (this.configPanel == null) {
            this.configPanel = new JPanel();
            this.configPanel.setOpaque(false);
            this.configPanel.setLayout(new FlowLayout(1, 2, 4));
            this.configPanel.add(this.getConfigurationComboBox());
            this.configPanel.add(this.getBtnDeleteConfiguration());
        }
        return this.configPanel;
    }

    protected JButton getBtnDeleteConfiguration() {
        if (this.btnDeleteConfiguration == null) {
            this.btnDeleteConfiguration = new JButton();
            this.btnDeleteConfiguration.setName("btnDeleteConfiguration");
            this.btnDeleteConfiguration.setPreferredSize(new Dimension(40, 24));
            this.btnDeleteConfiguration.setAction(new DeleteAction());
        }
        return this.btnDeleteConfiguration;
    }

    private class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            this.putValue("ShortDescription", Resources.getString("button.deleteConfiguration"));
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.remove"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageConfigurations.getInstance().delete((PageConfiguration)AlbumGeneratorPanel.this.getConfigurationComboBox().getSelectedItem());
        }
    }

    private class FileDocumentUpdate
    implements DocumentListener {
        private FileDocumentUpdate() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validateDocument(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validateDocument(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validateDocument(e);
        }

        private void validateDocument(DocumentEvent e) {
            boolean valid = false;
            if (!AlbumGeneratorPanel.this.getInputFileText().getText().isEmpty() && !AlbumGeneratorPanel.this.getOutputFolderText().getText().isEmpty()) {
                File input = new File(AlbumGeneratorPanel.this.getInputFileText().getText());
                if (input.exists() && input.isFile()) {
                    String filename = input.getName().substring(0, input.getName().lastIndexOf(46));
                    File output = new File(AlbumGeneratorPanel.this.getOutputFolderText().getText());
                    if (output.exists() && output.isDirectory()) {
                        File out = new File(output, filename + ".pdf");
                        AlbumGeneratorPanel.this.getModelBean().setInputFile(input);
                        AlbumGeneratorPanel.this.getModelBean().setOutputFile(out);
                    }
                }
                valid = AlbumGeneratorPanel.this.getModelBean().isValid();
            }
            AlbumGeneratorPanel.this.getBtnGenerate().getAction().setEnabled(valid);
        }
    }

    private class ChooseInputFile
    extends AbstractAction {
        public ChooseInputFile() {
            this.putValue("ShortDescription", Resources.getString("label.inputFile.tooltip"));
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.fileInput"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f;
            if (0 == AlbumGeneratorPanel.this.getInputFileChooser().showOpenDialog(AlbumGeneratorPanel.this.getBtnInputFile()) && (f = AlbumGeneratorPanel.this.getInputFileChooser().getSelectedFile()) != null) {
                if (f.getParent() != null) {
                    Preferences prefs = Resources.getPreferencesNode();
                    prefs.put("default-input-folder", f.getParent());
                    try {
                        prefs.flush();
                    }
                    catch (BackingStoreException e1) {
                        logger.log(Level.SEVERE, "Unable to save default folder.", e1);
                    }
                }
                AlbumGeneratorPanel.this.getInputFileText().setText(f.getAbsolutePath());
            }
        }
    }

    private class GenerateAction
    extends AbstractAction {
        public GenerateAction() {
            this.putValue("Name", Resources.getString("button.generate"));
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.generate"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Preferences prefs = Resources.getPreferencesNode();
            prefs.put("default-input-file", AlbumGeneratorPanel.this.getInputFileText().getText());
            EventBus.publish((Object)new StatusEvent(StatusEvent.StatusType.ShowBusy, (Object)Resources.getString("message.generating")));
            AlbumGeneratorPanel.this.getModelBean().setTags(AlbumGeneratorPanel.this.getTagText().getText());
            EventBus.publish((Object)new PdfAppEvent(PdfAppEvent.EventType.Generate, AlbumGeneratorPanel.this.getModelBean()));
            AlbumGeneratorPanel.this.getBtnOpenPdf().setEnabled(false);
        }
    }

    private class ChooseOutputFolder
    extends AbstractAction {
        public ChooseOutputFolder() {
            this.putValue("ShortDescription", Resources.getString("label.outputFolder.tooltip"));
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.folderOutput"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f;
            if (0 == AlbumGeneratorPanel.this.getOutputFolderChooser().showOpenDialog(AlbumGeneratorPanel.this.getBtnOutputFolder()) && (f = AlbumGeneratorPanel.this.getOutputFolderChooser().getSelectedFile()) != null) {
                Preferences prefs = Resources.getPreferencesNode();
                prefs.put("default-output-folder", f.getPath());
                AlbumGeneratorPanel.this.default_output_folder = f.getPath();
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e1) {
                    logger.log(Level.SEVERE, "Unable to save default folder.", e1);
                }
                AlbumGeneratorPanel.this.getOutputFolderText().setText(f.getAbsolutePath());
            }
        }
    }

    private class OpenPdfAction
    extends AbstractAction {
        public OpenPdfAction() {
            this.putValue("Name", Resources.getString("button.open"));
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.open"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Desktop.getDesktop().open(AlbumGeneratorPanel.this.getModelBean().getOutputFile());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private class ToggleReverseAction
    extends AbstractAction {
        public ToggleReverseAction() {
            this.putValue("Name", Resources.getString("label.renderReverse"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AlbumGeneratorPanel.this.getModelBean().setReversePages(AlbumGeneratorPanel.this.getCheckRenderReverse().isSelected());
        }
    }

    private class ToggleBordersAction
    extends AbstractAction {
        public ToggleBordersAction() {
            this.putValue("Name", Resources.getString("label.renderBorders"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AlbumGeneratorPanel.this.getModelBean().setDrawBorder(AlbumGeneratorPanel.this.getCheckRenderBorders().isSelected());
        }
    }

    private class OutputFileFilter
    extends FileFilter {
        private OutputFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() && f.canRead();
        }

        @Override
        public String getDescription() {
            return Resources.getString("filter.folder");
        }
    }

    private class InputFileFilter
    extends FileFilter {
        private InputFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() && f.canRead() || f.isFile() && f.canRead() && f.getName().toLowerCase().endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return Resources.getString("filter.xml");
        }
    }
}

