/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf.ui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.model.PageConfigurations;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.ui.ConfigurationRenderer;

public class NewConfigurationPanel
extends JPanel {
    private JLabel nameLabel;
    private JTextField nameText;
    private JLabel parentLabel;
    private JComboBox parentComboBox;

    public NewConfigurationPanel() {
        this.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.UNRELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC}));
        this.add((Component)this.getNameLabel(), "2, 2, right, default");
        this.add((Component)this.getNameText(), "4, 2, fill, default");
        this.add((Component)this.getParentLabel(), "2, 4, right, default");
        this.add((Component)this.getParentComboBox(), "4, 4, fill, default");
    }

    @Override
    public void requestFocus() {
        this.getNameText().requestFocusInWindow();
    }

    protected JLabel getNameLabel() {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel(Resources.getString("label.name"));
        }
        return this.nameLabel;
    }

    protected JTextField getNameText() {
        if (this.nameText == null) {
            this.nameText = new JTextField();
            this.nameText.setColumns(10);
        }
        return this.nameText;
    }

    protected JLabel getParentLabel() {
        if (this.parentLabel == null) {
            this.parentLabel = new JLabel(Resources.getString("label.copyFrom"));
        }
        return this.parentLabel;
    }

    protected JComboBox getParentComboBox() {
        if (this.parentComboBox == null) {
            this.parentComboBox = new JComboBox();
            this.parentComboBox.setRenderer(new ConfigurationRenderer());
        }
        return this.parentComboBox;
    }

    protected void loadConfigurations() {
        PageConfigurations configs = PageConfigurations.getInstance();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(configs.getConfigurations().toArray());
        this.getParentComboBox().setModel(model);
        this.getParentComboBox().setSelectedItem(configs.getActiveConfiguration());
    }

    public PageConfiguration getConfiguration() {
        PageConfiguration config = (PageConfiguration)this.getParentComboBox().getSelectedItem();
        config = config.duplicate();
        config.setName(this.getNameText().getText());
        config.setDisplayName(config.getName());
        return config;
    }
}

