/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf.ui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.javad.components.MessagePanel;
import org.javad.components.UIHelper;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.model.PageConfigurations;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.ui.IPageConfigurationSettingsPanel;

public class PageLayoutSettingsPanel
extends JPanel
implements IPageConfigurationSettingsPanel {
    private JFormattedTextField widthText;
    private JFormattedTextField heightText;
    private JFormattedTextField leftMarginText;
    private JFormattedTextField topMarginText;
    private JFormattedTextField rightMarginText;
    private JFormattedTextField bottomMarginText;
    private JFormattedTextField horizontalGapText;
    private JFormattedTextField verticalGapText;
    private JButton btnRevertDefault;
    private JLabel labelConfigurationValue;
    private PageConfiguration configuration;

    public PageLayoutSettingsPanel() {
        this.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.UNRELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode("12dlu"), FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode("12dlu"), FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC}));
        MessagePanel messagePanel = new MessagePanel(UIHelper.convertToMultiline((String)Resources.getString("message.pageLayout.helpText")));
        this.add((Component)messagePanel, "2, 2, 11, 1, fill, fill");
        JLabel labelConfiguration = new JLabel(Resources.getString("label.configuration"));
        this.add((Component)labelConfiguration, "2, 4, right, default");
        this.add((Component)this.getLabelConfigurationValue(), "4, 4, 9, 1");
        JLabel labelPageWidth = new JLabel("Paper Width:");
        this.add((Component)labelPageWidth, "2, 6, right, center");
        this.add((Component)this.getWidthText(), "4, 6, left, top");
        JLabel labelWidthDimension = new JLabel("(mm)");
        this.add((Component)labelWidthDimension, "6, 6");
        JLabel labelHorizontalGap = new JLabel("Horizontal Box Spacing:");
        this.add((Component)labelHorizontalGap, "8, 6, right, default");
        this.add((Component)this.getHorizontalGapText(), "10, 6, left, default");
        JLabel labelHorizontalGapDimension = new JLabel("(mm)");
        this.add((Component)labelHorizontalGapDimension, "12, 6");
        JLabel labelPageHeight = new JLabel("Paper Height:");
        this.add((Component)labelPageHeight, "2, 8, right, center");
        this.add((Component)this.getHeightText(), "4, 8, left, top");
        JLabel labelHeightDimension = new JLabel("(mm)");
        this.add((Component)labelHeightDimension, "6, 8");
        JLabel labelVerticalGap = new JLabel("Vertical Row Spacing:");
        this.add((Component)labelVerticalGap, "8, 8, right, default");
        this.add((Component)this.getVerticalGapText(), "10, 8, left, default");
        JLabel labelVerticalGapDimension = new JLabel("(mm)");
        this.add((Component)labelVerticalGapDimension, "12, 8");
        JLabel labelLeftMargin = new JLabel("Left Margin:");
        this.add((Component)labelLeftMargin, "2, 10, right, default");
        this.add((Component)this.getLeftMarginText(), "4, 10, left, default");
        JLabel labelLeftMarginDimension = new JLabel("(mm)");
        this.add((Component)labelLeftMarginDimension, "6, 10");
        JLabel labelTopMargin = new JLabel("Top Margin:");
        this.add((Component)labelTopMargin, "2, 12, right, default");
        this.add((Component)this.getTopMarginText(), "4, 12, left, default");
        JLabel labelTopMarginDimension = new JLabel("(mm)");
        this.add((Component)labelTopMarginDimension, "6, 12");
        JLabel labelRightMargin = new JLabel("Right Margin:");
        this.add((Component)labelRightMargin, "2, 14, right, default");
        this.add((Component)this.getRightMarginText(), "4, 14, left, default");
        JLabel labelRightMarginDimension = new JLabel("(mm)");
        this.add((Component)labelRightMarginDimension, "6, 14");
        JLabel labelBottomMargin = new JLabel("Bottom Margin:");
        this.add((Component)labelBottomMargin, "2, 16, right, default");
        this.add((Component)this.getBottomMarginText(), "4, 16, left, default");
        JLabel labelBottomMarginDimension = new JLabel("(mm)");
        this.add((Component)labelBottomMarginDimension, "6, 16");
        this.add((Component)this.getRevertDefault(), "8, 18, left, default");
    }

    protected JLabel getLabelConfigurationValue() {
        if (this.labelConfigurationValue == null) {
            this.labelConfigurationValue = new JLabel("");
            this.labelConfigurationValue.setName("label.configurationValue");
        }
        return this.labelConfigurationValue;
    }

    protected JButton getRevertDefault() {
        if (this.btnRevertDefault == null) {
            this.btnRevertDefault = new JButton(Resources.getString("button.revert"));
            this.btnRevertDefault.setName("btnRevertDefault");
            this.btnRevertDefault.setAction(new RevertAction());
        }
        return this.btnRevertDefault;
    }

    @Override
    public void setConfiguration(PageConfiguration configuration) {
        this.configuration = configuration;
    }

    protected JFormattedTextField getHorizontalGapText() {
        if (this.horizontalGapText == null) {
            this.horizontalGapText = new JFormattedTextField(NumberFormat.getInstance());
            this.horizontalGapText.setColumns(6);
        }
        return this.horizontalGapText;
    }

    protected JFormattedTextField getVerticalGapText() {
        if (this.verticalGapText == null) {
            this.verticalGapText = new JFormattedTextField(NumberFormat.getInstance());
            this.verticalGapText.setColumns(6);
        }
        return this.verticalGapText;
    }

    protected JFormattedTextField getBottomMarginText() {
        if (this.bottomMarginText == null) {
            this.bottomMarginText = new JFormattedTextField(NumberFormat.getInstance());
            this.bottomMarginText.setColumns(6);
        }
        return this.bottomMarginText;
    }

    protected JFormattedTextField getRightMarginText() {
        if (this.rightMarginText == null) {
            this.rightMarginText = new JFormattedTextField(NumberFormat.getInstance());
            this.rightMarginText.setColumns(6);
        }
        return this.rightMarginText;
    }

    protected JFormattedTextField getTopMarginText() {
        if (this.topMarginText == null) {
            this.topMarginText = new JFormattedTextField(NumberFormat.getInstance());
            this.topMarginText.setColumns(6);
        }
        return this.topMarginText;
    }

    private JFormattedTextField getLeftMarginText() {
        if (this.leftMarginText == null) {
            this.leftMarginText = new JFormattedTextField(NumberFormat.getInstance());
            this.leftMarginText.setColumns(6);
        }
        return this.leftMarginText;
    }

    protected JFormattedTextField getHeightText() {
        if (this.heightText == null) {
            this.heightText = new JFormattedTextField(NumberFormat.getInstance());
            this.heightText.setColumns(6);
        }
        return this.heightText;
    }

    protected JFormattedTextField getWidthText() {
        if (this.widthText == null) {
            this.widthText = new JFormattedTextField(NumberFormat.getInstance());
            this.widthText.setColumns(6);
        }
        return this.widthText;
    }

    public void configureForPageConfiguration(PageConfiguration config) {
        this.getLabelConfigurationValue().setText(config != null ? config.getDisplayName() : "unknown");
        this.getWidthText().setValue(config != null ? Float.valueOf(config.getWidth()) : null);
        this.getHeightText().setValue(config != null ? Float.valueOf(config.getHeight()) : null);
        this.getLeftMarginText().setValue(config != null ? Float.valueOf(config.getMarginLeft()) : null);
        this.getTopMarginText().setValue(config != null ? Float.valueOf(config.getMarginTop()) : null);
        this.getRightMarginText().setValue(config != null ? Float.valueOf(config.getMarginRight()) : null);
        this.getBottomMarginText().setValue(config != null ? Float.valueOf(config.getMarginBottom()) : null);
        this.getVerticalGapText().setValue(config != null ? Float.valueOf(config.getVerticalSpacing()) : null);
        this.getHorizontalGapText().setValue(config != null ? Float.valueOf(config.getHorizontalSpacing()) : null);
        this.getRevertDefault().getAction().setEnabled(config.isSystemConfiguration());
    }

    public void loadSettings() {
        if (this.configuration != null) {
            this.configureForPageConfiguration(this.configuration);
        }
    }

    public void saveSettings() {
        if (this.configuration != null) {
            this.configuration.setWidth(((Number)this.getWidthText().getValue()).floatValue());
            this.configuration.setHeight(((Number)this.getHeightText().getValue()).floatValue());
            this.configuration.setMarginLeft(((Number)this.getLeftMarginText().getValue()).floatValue());
            this.configuration.setMarginRight(((Number)this.getRightMarginText().getValue()).floatValue());
            this.configuration.setMarginTop(((Number)this.getTopMarginText().getValue()).floatValue());
            this.configuration.setMarginBottom(((Number)this.getBottomMarginText().getValue()).floatValue());
            this.configuration.setHorizontalSpacing(((Number)this.getHorizontalGapText().getValue()).floatValue());
            this.configuration.setVerticalSpacing(((Number)this.getVerticalGapText().getValue()).floatValue());
            PageConfigurations.getInstance().save(this.configuration);
        }
    }

    private class RevertAction
    extends AbstractAction {
        public RevertAction() {
            this.putValue("Name", Resources.getString("button.revert"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PageLayoutSettingsPanel.this.configuration != null && PageLayoutSettingsPanel.this.configuration.isSystemConfiguration()) {
                PageConfigurations.getInstance().revert(PageLayoutSettingsPanel.this.configuration);
                PageLayoutSettingsPanel.this.configureForPageConfiguration(PageLayoutSettingsPanel.this.configuration);
            }
        }
    }
}

