/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.javad.components.AboutDialog;
import org.javad.components.StatusPanel;
import org.javad.components.UIHelper;
import org.javad.components.model.AboutDialogBean;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.model.PageConfigurations;
import org.javad.stamp.htmlparser.ui.AlbumConversionPanel;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.events.PdfAppEvent;
import org.javad.stamp.pdf.ui.AlbumGeneratorPanel;
import org.javad.stamp.pdf.ui.NewConfigurationPanel;
import org.javad.stamp.pdf.ui.SettingsDialog;
import org.javad.stamp.pdf.ui.model.GenerateBean;
import org.javad.stamp.pdf.ui.tasks.GeneratePdfTask;
import org.javad.stamp.pdf.ui.tasks.GenerateXmlTask;

public class StampAlbumGenerator
extends JFrame {
    private JMenuBar menuBar;
    private JMenuItem menuFileExit;
    private AlbumGeneratorPanel albumGeneratorPanel;
    private AlbumConversionPanel albumConversionPanel;
    private static final Logger logger = Logger.getLogger(StampAlbumGenerator.class.getName());
    private StatusPanel statusPanel;
    private JMenu menuFile;
    private JMenu menuConfiguration;
    private JMenu menuHelp;
    private JMenuItem menuHelpAbout;
    private JMenuItem menuOptionsSettings;
    private JCheckBoxMenuItem menuConvertAlbum;
    private SettingsDialog settingsDialog;
    private JMenuItem menuConfigureNew;
    private JMenuItem menuConfigureReset;
    private JMenu menuOptions;
    private JCheckBoxMenuItem menuHelpLogging;
    private JMenu menuHelpDebug;

    public StampAlbumGenerator() {
        this.initialize();
    }

    protected void initialize() {
        this.setName("stamp-pagegen");
        this.setDefaultCloseOperation(2);
        AnnotationProcessor.process((Object)this);
        this.setJMenuBar(this.getMenuBar_1());
        this.setTitle(Resources.getString("title.generator.application"));
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource(Resources.getIconName("icon.application.generate"))));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "There was an error setting the icon for the application", e);
        }
        FontRegistry.getInstance().initializeFontPath();
        this.getContentPane().add((Component)((Object)this.getAlbumGeneratorPanel()), "Center");
        this.getContentPane().add((Component)this.getStatusPanel(), "South");
    }

    protected JMenuBar getMenuBar_1() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.menuBar.add(this.getMenuFile());
            this.menuBar.add(this.getMenuOptions());
            this.menuBar.add(this.getMenuHelp());
        }
        return this.menuBar;
    }

    protected JMenu getMenuFile() {
        if (this.menuFile == null) {
            this.menuFile = new JMenu(Resources.getString("menu.file"));
            this.menuFile.add(this.getMenuFileExit());
        }
        return this.menuFile;
    }

    protected JMenuItem getMenuFileExit() {
        if (this.menuFileExit == null) {
            this.menuFileExit = new JMenuItem(Resources.getString("menu.file.exit"));
            this.menuFileExit.setMnemonic(88);
            this.menuFileExit.setAction(new ExitAction());
        }
        return this.menuFileExit;
    }

    protected JMenu getMenuHelp() {
        if (this.menuHelp == null) {
            this.menuHelp = new JMenu(Resources.getString("menu.help"));
            this.menuHelp.add(this.getMenuHelpDebug());
            this.menuHelp.add(this.getMenuHelpAbout());
        }
        return this.menuHelp;
    }

    protected JMenuItem getMenuHelpAbout() {
        if (this.menuHelpAbout == null) {
            this.menuHelpAbout = new JMenuItem(Resources.getString("menu.help.about"));
            this.menuHelpAbout.setName("menu.help.about");
            this.menuHelpAbout.setAction(new HelpAboutAction());
        }
        return this.menuHelpAbout;
    }

    private JMenu getMenuConfiguration() {
        if (this.menuConfiguration == null) {
            this.menuConfiguration = new JMenu(Resources.getString("menu.configure"));
            this.menuConfiguration.add(this.getMenuConfigureNew());
            this.menuConfiguration.add(this.getMenuConfigureReset());
        }
        return this.menuConfiguration;
    }

    private JMenuItem getMenuOptionsSettings() {
        if (this.menuOptionsSettings == null) {
            this.menuOptionsSettings = new JMenuItem(Resources.getString("menu.options.settings"));
            this.menuOptionsSettings.setName("menu.options.settings");
            this.menuOptionsSettings.setAction(new OptionsAction());
        }
        return this.menuOptionsSettings;
    }

    private JCheckBoxMenuItem getMenuConvertAlbum() {
        if (this.menuConvertAlbum == null) {
            this.menuConvertAlbum = new JCheckBoxMenuItem(Resources.getString("menu.options.convert"));
            this.menuConvertAlbum.setName("menu.options.convert");
            this.menuConvertAlbum.setAction(new ConvertAction());
        }
        return this.menuConvertAlbum;
    }

    protected JMenuItem getMenuConfigureNew() {
        if (this.menuConfigureNew == null) {
            this.menuConfigureNew = new JMenuItem(Resources.getString("menu.configure.newConfig"));
            this.menuConfigureNew.setName("menu.configure.new");
            this.menuConfigureNew.setAction(new NewConfigurationAction());
        }
        return this.menuConfigureNew;
    }

    protected JMenuItem getMenuConfigureReset() {
        if (this.menuConfigureReset == null) {
            this.menuConfigureReset = new JMenuItem(Resources.getString("menu.configure.resetAll"));
            this.menuConfigureReset.setName("menu.configure.reset");
            this.menuConfigureReset.setAction(new ResetConfigurationAction());
        }
        return this.menuConfigureReset;
    }

    protected JMenu getMenuOptions() {
        if (this.menuOptions == null) {
            this.menuOptions = new JMenu(Resources.getString("menu.options"));
            this.menuOptions.add(this.getMenuConfiguration());
            this.menuOptions.add(this.getMenuOptionsSettings());
            this.menuOptions.add(this.getMenuConvertAlbum());
        }
        return this.menuOptions;
    }

    protected JCheckBoxMenuItem getMenuHelpLogging() {
        if (this.menuHelpLogging == null) {
            this.menuHelpLogging = new JCheckBoxMenuItem(new VerboseLoggingAction());
            this.menuHelpLogging.setName("menu.help.logging");
        }
        return this.menuHelpLogging;
    }

    protected JMenu getMenuHelpDebug() {
        if (this.menuHelpDebug == null) {
            this.menuHelpDebug = new JMenu(Resources.getString("menu.help.debug"));
            this.menuHelpDebug.setIcon(Resources.getIcon("icon.support"));
            this.menuHelpDebug.add(this.getMenuHelpLogging());
        }
        return this.menuHelpDebug;
    }

    private void disposeWindow() {
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    private static void createAndShowGUI() {
        final StampAlbumGenerator creator = new StampAlbumGenerator();
        creator.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                AnnotationProcessor.unprocess((Object)creator);
                EventBus.clearAllSubscribers();
                System.exit(0);
            }
        });
        creator.setSize(680, 500);
        creator.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StampAlbumGenerator.createAndShowGUI();
            }
        });
    }

    protected AlbumConversionPanel getAlbumConversionPanel() {
        if (this.albumConversionPanel == null) {
            this.albumConversionPanel = new AlbumConversionPanel();
            this.albumConversionPanel.setBorder(new SoftBevelBorder(0, null, null, null, null));
        }
        return this.albumConversionPanel;
    }

    protected AlbumGeneratorPanel getAlbumGeneratorPanel() {
        if (this.albumGeneratorPanel == null) {
            this.albumGeneratorPanel = new AlbumGeneratorPanel();
            this.albumGeneratorPanel.getOutputFolderText().setEditable(false);
            this.albumGeneratorPanel.getInputFileText().setEditable(false);
            this.albumGeneratorPanel.setBorder(new SoftBevelBorder(0, null, null, null, null));
        }
        return this.albumGeneratorPanel;
    }

    protected StatusPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new StatusPanel(){

                protected JLabel getLblStatusLabel() {
                    JLabel label = super.getLblStatusLabel();
                    label.setForeground(Color.BLACK);
                    return label;
                }
            };
            this.statusPanel.setForeground(new Color(211, 211, 211));
            this.statusPanel.setBackground(new Color(248, 248, 255));
            this.statusPanel.showPositionLabel(false);
            this.statusPanel.showZoomLabel(false);
        }
        return this.statusPanel;
    }

    @EventSubscriber(eventClass=PdfAppEvent.class)
    public void handleAppEvent(PdfAppEvent event) {
        if (event.getType() == PdfAppEvent.EventType.Generate) {
            GenerateBean bean = (GenerateBean)event.getData();
            GeneratePdfTask task = new GeneratePdfTask(bean);
            task.execute();
        } else if (event.getType() == PdfAppEvent.EventType.GenerateXml) {
            Map fileMap = (Map)event.getData();
            GenerateXmlTask task = new GenerateXmlTask(fileMap);
            task.execute();
        }
    }

    protected SettingsDialog getSettingsDialog() {
        if (this.settingsDialog == null) {
            this.settingsDialog = new SettingsDialog(this);
        }
        return this.settingsDialog;
    }

    public class VerboseLoggingAction
    extends AbstractAction {
        public VerboseLoggingAction() {
            this.putValue("Name", Resources.getString("menu.help.logging"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Level level = StampAlbumGenerator.this.getMenuHelpLogging().isSelected() ? Level.FINEST : Level.INFO;
            Logger logger = Logger.getLogger("org.javad");
            logger.setLevel(level);
        }
    }

    public class HelpAboutAction
    extends AbstractAction {
        public HelpAboutAction() {
            this.putValue("Name", Resources.getString("menu.help.about"));
            this.putValue("SmallIcon", Resources.getIcon("icon.help.about"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialogBean bean = new AboutDialogBean();
            bean.setTitle(Resources.getString("title.helpAbout.application"));
            bean.setApplicationIcon(Resources.getIcon("icon.application.large"));
            bean.setApplicationInfo(Resources.getString("label.helpAbout.applicationInfo"));
            bean.setApplicationLink(Resources.getString("label.helpAbout.applicationLink"));
            AboutDialog dialog = new AboutDialog(bean);
            UIHelper.center((Component)StampAlbumGenerator.this.getRootPane(), (JDialog)dialog);
            dialog.setVisible(true);
        }
    }

    public class ResetConfigurationAction
    extends AbstractAction {
        public ResetConfigurationAction() {
            this.putValue("Name", Resources.getString("menu.configure.resetAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int result = JOptionPane.showConfirmDialog((Component)((Object)StampAlbumGenerator.this.getAlbumGeneratorPanel()), Resources.getString("message.resetAll"), Resources.getString("title.resetAll"), 0);
            if (result == 0) {
                PageConfigurations.getInstance().revertAll();
            }
        }
    }

    public class OptionsAction
    extends AbstractAction {
        public OptionsAction() {
            this.putValue("Name", Resources.getString("menu.options.settings"));
            this.putValue("SmallIcon", Resources.getIcon("icon.settings"));
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.settings.medium"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIHelper.center((Component)StampAlbumGenerator.this.getRootPane(), (JDialog)StampAlbumGenerator.this.getSettingsDialog());
            StampAlbumGenerator.this.getSettingsDialog().setVisible(true);
        }
    }

    public class ConvertAction
    extends AbstractAction {
        public ConvertAction() {
            this.putValue("Name", Resources.getString("menu.options.convert"));
            this.putValue("SmallIcon", Resources.getIcon("icon.convert"));
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.convert.medium"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StampAlbumGenerator.this.getMenuConvertAlbum().isSelected()) {
                StampAlbumGenerator.this.getContentPane().remove((Component)((Object)StampAlbumGenerator.this.getAlbumGeneratorPanel()));
                StampAlbumGenerator.this.getContentPane().add((Component)((Object)StampAlbumGenerator.this.getAlbumConversionPanel()), "Center");
            } else {
                StampAlbumGenerator.this.getContentPane().remove((Component)((Object)StampAlbumGenerator.this.getAlbumConversionPanel()));
                StampAlbumGenerator.this.getContentPane().add((Component)((Object)StampAlbumGenerator.this.getAlbumGeneratorPanel()), "Center");
            }
            StampAlbumGenerator.this.getContentPane().doLayout();
            StampAlbumGenerator.this.getContentPane().paintAll(StampAlbumGenerator.this.getContentPane().getGraphics());
        }
    }

    public class NewConfigurationAction
    extends AbstractAction {
        public NewConfigurationAction() {
            this.putValue("Name", Resources.getString("menu.configure.newConfig"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewConfigurationPanel panel = new NewConfigurationPanel();
            panel.loadConfigurations();
            int result = JOptionPane.showOptionDialog((Component)((Object)StampAlbumGenerator.this.getAlbumGeneratorPanel()), panel, Resources.getString("title.newConfiguration"), 2, -1, null, null, null);
            if (result == 0) {
                PageConfiguration config = panel.getConfiguration();
                PageConfigurations.getInstance().create(config);
            }
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            this.putValue("Name", Resources.getString("menu.file.exit"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StampAlbumGenerator.this.disposeWindow();
        }
    }
}

