/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf.ui.tasks;

import com.itextpdf.text.ExceptionConverter;
import javax.swing.SwingWorker;
import org.bushe.swing.event.EventBus;
import org.javad.events.StatusEvent;
import org.javad.stamp.pdf.PdfGenerator;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.events.PdfAppEvent;
import org.javad.stamp.pdf.ui.model.GenerateBean;

public class GeneratePdfTask
extends SwingWorker<Void, Void> {
    private GenerateBean bean;
    private boolean errorRaised = false;

    public GeneratePdfTask(GenerateBean bean) {
        this.bean = bean;
    }

    @Override
    protected Void doInBackground() throws Exception {
        PdfGenerator generator = new PdfGenerator();
        try {
            generator.generate(this.bean);
        }
        catch (Throwable e2) {
            Exception e2;
            this.errorRaised = true;
            if (e2 instanceof ExceptionConverter) {
                e2 = ((ExceptionConverter)e2).getException();
            }
            EventBus.publish((Object)new PdfAppEvent(PdfAppEvent.EventType.Generate_Error, e2));
        }
        return null;
    }

    @Override
    protected void done() {
        EventBus.publish((Object)new StatusEvent(StatusEvent.StatusType.Finished, (Object)Resources.getString("message.finished")));
        if (!this.errorRaised) {
            EventBus.publish((Object)new PdfAppEvent(PdfAppEvent.EventType.Generated, null));
        }
    }
}

