/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.xml;

import org.javad.pdf.SpacingMode;
import org.javad.pdf.model.PageConfiguration;
import org.javad.stamp.pdf.CompositeRow;
import org.javad.stamp.pdf.StampRow;
import org.javad.stamp.xml.AbstractXMLParser;
import org.javad.stamp.xml.XMLDefinitions;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CompositeRowParser
extends AbstractXMLParser<CompositeRow>
implements XMLDefinitions {
    @Override
    public CompositeRow parse(Element element, PageConfiguration configuration) {
        NodeList compSets;
        CompositeRow compRow = new CompositeRow(configuration);
        if (element.hasAttribute("skip")) {
            compRow.parseSkipTerms(element.getAttribute("skip"));
        }
        if (element.getAttribute("description") != null) {
            compRow.setDescription(element.getAttribute("description"));
        }
        if (element.hasAttribute("spacing")) {
            compRow.setSpacingMode(SpacingMode.valueOf(element.getAttribute("spacing").toLowerCase()));
        }
        if ((compSets = element.getChildNodes()) != null) {
            for (int j = 0; j < compSets.getLength(); ++j) {
                Element rowSet2 = (Element)compSets.item(j);
                StampRow row2 = (StampRow)CompositeRowParser.getFactory().getParser("row-set").parse(rowSet2, configuration);
                if (row2 == null) continue;
                compRow.addStampRow(row2);
            }
        }
        return compRow;
    }
}

