/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.xml;

import java.util.Set;
import org.javad.pdf.ISetContent;
import org.javad.pdf.Page;
import org.javad.pdf.PageTitle;
import org.javad.pdf.model.PageConfiguration;
import org.javad.stamp.xml.AbstractXMLParser;
import org.javad.stamp.xml.XMLDefinitions;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PageParser
extends AbstractXMLParser<Page>
implements XMLDefinitions {
    @Override
    public Page parse(Element element, PageConfiguration configuration) {
        Set<String> skipTerms = configuration.getSkipTerms();
        if (element.hasAttribute("skip") && !skipTerms.isEmpty()) {
            for (String t : element.getAttribute("skip").split(" ")) {
                if (!skipTerms.contains(t)) continue;
                return null;
            }
        }
        Page p = new Page();
        PageTitle pt = new PageTitle(configuration);
        if (element.hasAttribute("title")) {
            pt.setTitle(element.getAttribute("title").replace("\\n", "\n"));
        }
        if (element.hasAttribute("subtitle")) {
            pt.setSubTitle(element.getAttribute("subtitle").replace("\\n", "\n"));
        }
        if (element.hasAttribute("classifier")) {
            pt.setClassifier(element.getAttribute("classifier"));
        }
        p.setTitle(pt);
        NodeList children = element.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Element elm = (Element)children.item(i);
                ISetContent content = null;
                if (elm.getTagName().equals("set")) {
                    content = (ISetContent)PageParser.getFactory().getParser("set").parse(elm, configuration);
                } else if (elm.getTagName().equals("column-set")) {
                    content = (ISetContent)PageParser.getFactory().getParser("column-set").parse(elm, configuration);
                }
                if (content == null) continue;
                p.addContent(content);
            }
        }
        return p;
    }
}

