/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.xml;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.javad.pdf.model.PageConfiguration;
import org.javad.stamp.pdf.StampBox;
import org.javad.stamp.xml.AbstractXMLParser;
import org.javad.stamp.xml.XMLDefinitions;
import org.w3c.dom.Element;

public class StampBoxParser
extends AbstractXMLParser<StampBox>
implements XMLDefinitions {
    public static final int DIMENSION = 0;
    public static final int DENOMINATION = 1;
    public static final int DESCRIPTION = 2;
    public static final int DESCRIPTION_SECONDARY = 3;
    public static final int CATALOGUE_NUMBER = 4;
    private static Logger logger = Logger.getLogger(StampBoxParser.class.getName());

    @Override
    public StampBox parse(Element element, PageConfiguration configuration) {
        StampBox stamp = null;
        String content = element.getTextContent();
        if (content != null && !content.isEmpty()) {
            String[] vars;
            stamp = new StampBox(configuration);
            if (element.hasAttribute("skip")) {
                stamp.parseSkipTerms(element.getAttribute("skip"));
            }
            if (element.hasAttribute("image")) {
                String imagePath = element.getAttribute("image");
                try {
                    File imageFile = new File(imagePath);
                    File folder = StampBoxParser.getFactory().getWorkingFolder();
                    if (folder != null) {
                        imageFile = new File(folder, imagePath);
                    }
                    if (imageFile.exists()) {
                        BufferedImage img = ImageIO.read(imageFile);
                        stamp.setImage(img);
                    } else {
                        logger.warning("The image file: " + imagePath + " was not found relative to the album xml file.");
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not load the image " + imagePath, e);
                }
            }
            if (element.hasAttribute("image-only")) {
                stamp.setImageOnly(Boolean.valueOf(element.getAttribute("image-only")));
            }
            if (element.hasAttribute("border")) {
                stamp.setBorder(Boolean.valueOf(element.getAttribute("border")));
            }
            if (element.hasAttribute("bisect")) {
                String bisect = element.getAttribute("bisect");
                stamp.setBisect(StampBox.Bisect.valueOf(bisect));
            }
            if (element.hasAttribute("shape")) {
                String shape = element.getAttribute("shape");
                stamp.setShape(StampBox.Shape.valueOf(shape));
            }
            if ((vars = content.trim().split("\"(\\s|,)\"")).length > 0) {
                block9: for (int i = 0; i < vars.length; ++i) {
                    switch (i) {
                        case 0: {
                            String[] dim = (vars[i].startsWith("\"") ? vars[i].substring(1) : vars[i]).split(" ");
                            if (dim.length != 2) {
                                logger.warning("the dimension variable only supports two dimensions: " + vars[i]);
                            }
                            stamp.setWidth(Integer.parseInt(dim[0]));
                            if (dim[1].endsWith("\"")) {
                                dim[1] = dim[1].substring(0, dim[1].length() - 1);
                            }
                            stamp.setHeight(Integer.parseInt(dim[1]));
                            continue block9;
                        }
                        case 1: {
                            stamp.setDenomination(vars[i]);
                            continue block9;
                        }
                        case 2: {
                            stamp.setDescription(vars[i]);
                            continue block9;
                        }
                        case 3: {
                            if (vars[i].trim().isEmpty()) continue block9;
                            stamp.setDescriptionSecondary(vars[i]);
                            continue block9;
                        }
                        case 4: {
                            String num = vars[i].endsWith("\"") ? vars[i].substring(0, vars[i].length() - 1) : vars[i];
                            stamp.setCatalogueNumber(num);
                        }
                    }
                }
            }
        }
        return stamp;
    }
}

