/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.xml;

import org.javad.pdf.ISetContent;
import org.javad.pdf.model.PageConfiguration;
import org.javad.stamp.pdf.StampSet;
import org.javad.stamp.xml.AbstractXMLParser;
import org.javad.stamp.xml.XMLDefinitions;
import org.javad.xml.XML;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StampSetParser
extends AbstractXMLParser<StampSet>
implements XMLDefinitions {
    @Override
    public StampSet parse(Element set, PageConfiguration configuration) {
        NodeList rowSets;
        StampSet stampSet = new StampSet(configuration);
        if (set.hasAttribute("skip")) {
            stampSet.parseSkipTerms(set.getAttribute("skip"));
        }
        if (set.hasAttribute("issue")) {
            stampSet.setIssue(XML.normalize(set.getAttribute("issue")));
        }
        stampSet.setDescription(XML.normalize(set.getAttribute("description")));
        if (set.hasAttribute("description-secondary")) {
            stampSet.setDescriptionSecondary(XML.normalize(set.getAttribute("description-secondary")));
        }
        if (set.hasAttribute("comment")) {
            stampSet.setComment(XML.normalize(set.getAttribute("comment")));
        }
        if ((rowSets = set.getChildNodes()) != null) {
            for (int i = 0; i < rowSets.getLength(); ++i) {
                ISetContent content = null;
                Element rowSet = (Element)rowSets.item(i);
                if (rowSet.getTagName().equals("row-set")) {
                    content = (ISetContent)StampSetParser.getFactory().getParser("row-set").parse(rowSet, configuration);
                } else if (rowSet.getTagName().equals("comp-set")) {
                    content = (ISetContent)StampSetParser.getFactory().getParser("comp-set").parse(rowSet, configuration);
                }
                if (content == null) continue;
                stampSet.addContentRow(content);
            }
        }
        return stampSet;
    }
}

