/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.xml;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.javad.xml.IXMLContentParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class StampXMLParserFactory {
    private static StampXMLParserFactory instance = null;
    private File parseFile = null;
    private static final Logger logger = Logger.getLogger(StampXMLParserFactory.class.getName());
    private Map<String, IXMLContentParser<?>> parsers = new HashMap();

    private void initialize() {
        Properties props = new Properties();
        try {
            props.loadFromXML(this.getClass().getResourceAsStream("/META-INF/xml-stampparsers.xml"));
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                try {
                    Class<?> clazz = Class.forName(entry.getValue().toString());
                    if (clazz == null || !IXMLContentParser.class.isAssignableFrom(clazz)) continue;
                    this.parsers.put(entry.getKey().toString(), (IXMLContentParser)clazz.newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An error occured configuring the XML parsers", e);
        }
    }

    public static StampXMLParserFactory getInstance() {
        if (instance == null) {
            instance = new StampXMLParserFactory();
            instance.initialize();
        }
        return instance;
    }

    public Document getDocument(File inputFile) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setIgnoringComments(true);
        docFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = docFactory.newDocumentBuilder();
        Document xmlDoc = null;
        try {
            xmlDoc = builder.parse(inputFile);
            this.setParseFile(inputFile);
        }
        catch (SAXParseException spe) {
            logger.log(Level.SEVERE, "Line " + (spe.getLineNumber() - 1) + ": Parsing Error - " + spe.getMessage(), spe);
            throw new Exception("Unable to continue parsing the document.");
        }
        return xmlDoc;
    }

    public File getWorkingFolder() throws IllegalStateException {
        if (this.parseFile == null) {
            throw new IllegalStateException("The parsing file is not set.");
        }
        if (this.parseFile.getParent() != null) {
            return new File(this.parseFile.getParent());
        }
        return null;
    }

    public File getParseFile() {
        return this.parseFile;
    }

    public void setParseFile(File parseFile) {
        this.parseFile = parseFile;
    }

    public IXMLContentParser<?> getParser(String tagName) {
        IXMLContentParser<?> parser = null;
        if (tagName != null && this.parsers.containsKey(tagName)) {
            parser = this.parsers.get(tagName);
        }
        return parser;
    }

    public IXMLContentParser<?> getParser(Element element) {
        IXMLContentParser<?> parser = null;
        if (element != null && this.parsers.containsKey(element.getTagName())) {
            parser = this.parsers.get(element.getTagName());
        }
        return parser;
    }
}

