/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.xml;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.javad.pdf.TitlePage;
import org.javad.pdf.TitlePageContent;
import org.javad.pdf.model.PageConfiguration;
import org.javad.stamp.xml.AbstractXMLParser;
import org.javad.stamp.xml.XMLDefinitions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TitlePageParser
extends AbstractXMLParser<TitlePage>
implements XMLDefinitions {
    private static final Logger logger = Logger.getLogger(TitlePageParser.class.getName());

    @Override
    public TitlePage parse(Element element, PageConfiguration configuration) {
        NodeList children;
        Set<String> skipTerms = configuration.getSkipTerms();
        if (element.hasAttribute("skip") && !skipTerms.isEmpty()) {
            for (String t : element.getAttribute("skip").split(" ")) {
                if (!skipTerms.contains(t)) continue;
                return null;
            }
        }
        TitlePage p = new TitlePage();
        TitlePageContent pt = new TitlePageContent(configuration);
        p.setTitlePageContent(pt);
        if (element.hasAttribute("title")) {
            pt.setTitle(element.getAttribute("title").replace("\\n", "\n"));
        }
        if (element.hasAttribute("subtitle")) {
            pt.setSubTitle(element.getAttribute("subtitle").replace("\\n", "\n"));
        }
        if (element.hasAttribute("description")) {
            pt.setDescription(element.getAttribute("description").replace("\\n", "\n"));
        }
        if (element.hasAttribute("image")) {
            String imagePath = element.getAttribute("image");
            try {
                File imageFile = new File(imagePath);
                File folder = TitlePageParser.getFactory().getWorkingFolder();
                if (folder != null) {
                    imageFile = new File(folder, imagePath);
                }
                if (imageFile.exists()) {
                    BufferedImage img = ImageIO.read(imageFile);
                    pt.setImage(img);
                } else {
                    logger.log(Level.WARNING, "The image file: {0} was not found relative to the album xml file.", imagePath);
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not load the image " + imagePath, e);
            }
        }
        if (element.hasChildNodes() && (children = element.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                NodeList contentChildren;
                Node elm = children.item(i);
                if (!elm.getNodeName().equals("content-items") || (contentChildren = elm.getChildNodes()) == null) continue;
                for (int j = 0; j < contentChildren.getLength(); ++j) {
                    Node c_elm = contentChildren.item(j);
                    if (!c_elm.getNodeName().equals("item")) continue;
                    String item = c_elm.getTextContent();
                    pt.getItems().add(item);
                }
            }
        }
        return p;
    }
}

