/*
 * Decompiled with CFR 0.152.
 */
package colorzoo.swing.gradient;

import colorzoo.swing.ColorSelectionButton;
import colorzoo.swing.ColorUtil;
import colorzoo.swing.EnumComboBoxModel;
import colorzoo.swing.JMultiThumbSlider;
import colorzoo.swing.Thumb;
import colorzoo.swing.gradient.GradientPreviewPanel;
import colorzoo.swing.gradient.GradientThumbRenderer;
import colorzoo.swing.gradient.GradientTrackRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradientPicker
extends JPanel {
    Paint checker_texture = null;
    JMultiThumbSlider<Color> slider = null;
    public JButton add_thumb_button;
    public JSlider alpha_slider;
    public JSpinner alpha_value;
    public ButtonGroup buttonGroup1;
    public JButton change_color;
    public JSpinner color_location_field;
    public JTextField color_value;
    public JButton delete_thumb_button;
    public JPanel gradientPreview;
    public JPanel gradient_selector;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JLabel jLabel6;
    public JLabel jLabel7;
    public JPanel jPanel1;
    public JPanel jPanel2;
    public JPanel jPanel3;
    public JPanel jPanel4;
    public JSpinner jSpinner1;
    public JButton minus_button;
    public JRadioButton no_cycle;
    public JButton plus_button;
    public JRadioButton reflected;
    public JRadioButton repeated;
    public JCheckBox reversed;
    public JComboBox style_list;

    public GradientPicker() {
        this.initComponents();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(100, 0, 100, 1);
        this.alpha_value.setModel(spinnerNumberModel);
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(100, 0, 100, 1);
        this.color_location_field.setModel(spinnerNumberModel2);
        this.checker_texture = ColorUtil.getCheckerPaint();
        this.gradient_selector.setLayout(new BorderLayout());
        this.slider = new JMultiThumbSlider();
        this.slider.setOpaque(false);
        this.slider.setPreferredSize(new Dimension(100, 35));
        this.slider.getModel().setMinimumValue(0.0f);
        this.slider.getModel().setMaximumValue(1.0f);
        this.slider.getModel().addThumb(0.0f, Color.black);
        this.slider.getModel().addThumb(0.5f, Color.red);
        this.slider.getModel().addThumb(1.0f, Color.white);
        this.slider.setThumbRenderer(new GradientThumbRenderer(this, this.slider));
        this.slider.setTrackRenderer(new GradientTrackRenderer(this));
        this.slider.addMultiThumbListener(new StopListener(this.slider));
        this.gradient_selector.add(this.slider, "Center");
        this.change_color.addActionListener(new ChangeColorListener(this.slider));
        this.alpha_slider.addChangeListener(new ChangeAlphaListener(this.slider));
        AddThumbListener addThumbListener = new AddThumbListener(this.slider);
        this.add_thumb_button.addActionListener(addThumbListener);
        this.plus_button.addActionListener(addThumbListener);
        DeleteThumbListener deleteThumbListener = new DeleteThumbListener(this.slider);
        this.delete_thumb_button.addActionListener(deleteThumbListener);
        this.minus_button.addActionListener(deleteThumbListener);
        ((GradientPreviewPanel)this.gradientPreview).picker = this;
        this.reflected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GradientPicker.this.gradientPreview.repaint();
            }
        });
        this.reversed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GradientPicker.this.gradientPreview.repaint();
            }
        });
        this.repeated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GradientPicker.this.gradientPreview.repaint();
            }
        });
        this.no_cycle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GradientPicker.this.gradientPreview.repaint();
            }
        });
        this.style_list.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GradientPicker.this.gradientPreview.repaint();
            }
        });
        this.style_list.setModel(new EnumComboBoxModel());
    }

    public MultipleGradientPaint getGradient() {
        List<Thumb<Color>> list = this.slider.getModel().getSortedThumbs();
        int n = list.size();
        float[] fArray = new float[n];
        Color[] colorArray = new Color[n];
        int n2 = 0;
        for (Thumb<Color> object2 : list) {
            colorArray[n2] = object2.getObject();
            fArray[n2] = object2.getPosition();
            ++n2;
        }
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(this.getWidth(), 0.0f);
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint((float)((Point2D)float_).getX(), (float)((Point2D)float_).getY(), (float)((Point2D)float_2).getX(), (float)((Point2D)float_2).getY(), fArray, colorArray);
        return linearGradientPaint;
    }

    public void setGradient(MultipleGradientPaint multipleGradientPaint) {
        while (this.slider.getModel().getThumbCount() > 0) {
            this.slider.getModel().removeThumb(0);
        }
        float[] fArray = multipleGradientPaint.getFractions();
        Color[] colorArray = multipleGradientPaint.getColors();
        for (int i = 0; i < fArray.length; ++i) {
            this.slider.getModel().addThumb(fArray[i], colorArray[i]);
        }
        this.repaint();
    }

    private void updateFromStop(Thumb<Color> thumb) {
        if (thumb == null) {
            this.updateFromStop(-1, -1.0f, Color.black);
        } else {
            this.updateFromStop(1, thumb.getPosition(), thumb.getObject());
        }
    }

    private void updateFromStop(int n, float f, Color color) {
        if (n == -1) {
            this.color_location_field.setEnabled(false);
            this.alpha_value.setEnabled(false);
            this.alpha_slider.setEnabled(false);
            this.color_value.setEnabled(false);
            this.change_color.setEnabled(false);
            this.change_color.setBackground(Color.black);
            this.delete_thumb_button.setEnabled(false);
            this.minus_button.setEnabled(false);
        } else {
            this.color_location_field.setEnabled(true);
            this.alpha_value.setEnabled(true);
            this.alpha_slider.setEnabled(true);
            this.color_value.setEnabled(true);
            this.change_color.setEnabled(true);
            this.color_location_field.setValue((int)(100.0f * f));
            this.color_value.setText(Integer.toHexString(color.getRGB()).substring(2));
            this.alpha_value.setValue(color.getAlpha() * 100 / 255);
            this.alpha_slider.setValue(color.getAlpha() * 100 / 255);
            this.change_color.setBackground(color);
            this.delete_thumb_button.setEnabled(true);
            this.minus_button.setEnabled(true);
        }
        this.updateDeleteButtons();
        ((GradientPreviewPanel)this.gradientPreview).repaint();
    }

    private void updateDeleteButtons() {
        if (this.slider.getModel().getThumbCount() <= 2) {
            this.delete_thumb_button.setEnabled(false);
            this.minus_button.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jSpinner1 = new JSpinner();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel6 = new JLabel();
        this.color_value = new JTextField();
        this.jLabel4 = new JLabel();
        this.change_color = new ColorSelectionButton();
        this.jLabel5 = new JLabel();
        this.delete_thumb_button = new JButton();
        this.add_thumb_button = new JButton();
        this.color_location_field = new JSpinner();
        this.alpha_slider = new JSlider();
        this.alpha_value = new JSpinner();
        this.jPanel1 = new JPanel();
        this.gradientPreview = new GradientPreviewPanel();
        this.jLabel7 = new JLabel();
        this.style_list = new JComboBox();
        this.reversed = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.no_cycle = new JRadioButton();
        this.repeated = new JRadioButton();
        this.reflected = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.plus_button = new JButton();
        this.minus_button = new JButton();
        this.gradient_selector = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder("Gradient Picker"));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Stops"));
        this.jLabel1.setText("Opacity:");
        this.jLabel2.setText("%");
        this.jLabel3.setText("Color:");
        this.jLabel6.setText("%");
        this.color_value.setText("000");
        this.color_value.setEnabled(false);
        this.jLabel4.setText("Location:");
        this.change_color.setText("Color");
        this.change_color.setEnabled(false);
        this.jLabel5.setText("#");
        this.delete_thumb_button.setText("Delete");
        this.delete_thumb_button.setEnabled(false);
        this.add_thumb_button.setText("Add");
        this.color_location_field.setEnabled(false);
        this.color_location_field.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GradientPicker.this.mystatechanged(changeEvent);
            }
        });
        this.alpha_slider.setEnabled(false);
        this.alpha_value.setEnabled(false);
        this.alpha_value.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GradientPicker.this.alpha_valueStateChanged(changeEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.delete_thumb_button).addPreferredGap(0).add((Component)this.add_thumb_button)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(15, 15, 15).add((Component)this.jLabel3)).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel5).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.jLabel6)))).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jLabel2))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add(2, (Component)this.alpha_value).add(2, (Component)this.color_location_field).add(2, (Component)this.color_value, -1, 68, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.alpha_slider, 0, 0, Short.MAX_VALUE).add((Component)this.change_color, -1, -1, Short.MAX_VALUE)))).addContainerGap(102, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.delete_thumb_button).add((Component)this.add_thumb_button)).add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jLabel5).add((Component)this.color_value, -2, -1, -2).add((Component)this.change_color)).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jLabel6).add((Component)this.color_location_field, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel1).add((Component)this.alpha_value, -2, -1, -2))).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(27, 27, 27).add((Component)this.alpha_slider, -2, 25, -2)))));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.gradientPreview.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.gradientPreview);
        this.gradientPreview.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(0, 199, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(0, 146, Short.MAX_VALUE));
        this.jLabel7.setText("Style");
        this.style_list.setModel(new DefaultComboBoxModel<String>(new String[]{"Linear", "Radial"}));
        this.reversed.setText("Reverse");
        this.reversed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reversed.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.buttonGroup1.add(this.no_cycle);
        this.no_cycle.setSelected(true);
        this.no_cycle.setText("None");
        this.no_cycle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.no_cycle.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.repeated);
        this.repeated.setText("Repeat");
        this.repeated.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.repeated.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.reflected);
        this.reflected.setText("Reflect");
        this.reflected.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reflected.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.no_cycle).add((Component)this.repeated).add((Component)this.reflected)).addContainerGap(16, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.no_cycle).addPreferredGap(0).add((Component)this.repeated).addPreferredGap(0).add((Component)this.reflected).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1, false).add(2, (Component)this.jPanel3, 0, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.style_list, -2, -1, -2)).add((Component)this.reversed)).addPreferredGap(0).add((Component)this.gradientPreview).addContainerGap()));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.gradientPreview).add(1, (GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.style_list, -2, -1, -2)).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0).add((Component)this.reversed))).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(""));
        this.plus_button.setText("+");
        this.minus_button.setText("-");
        this.minus_button.setEnabled(false);
        GroupLayout groupLayout5 = new GroupLayout((Container)this.gradient_selector);
        this.gradient_selector.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 261, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 52, Short.MAX_VALUE));
        GroupLayout groupLayout6 = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)this.gradient_selector).addPreferredGap(0).add((GroupLayout.Group)groupLayout6.createParallelGroup(2).add((Component)this.plus_button, -2, 41, -2).add((Component)this.minus_button))));
        groupLayout6.linkSize(new Component[]{this.minus_button, this.plus_button}, 1);
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)this.plus_button).addPreferredGap(0).add((Component)this.minus_button, -2, 23, -2)).add(2, (Component)this.gradient_selector));
        GroupLayout groupLayout7 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout7);
        groupLayout7.setHorizontalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout7.createSequentialGroup().add((Component)this.jPanel1).addContainerGap()).add(1, (GroupLayout.Group)groupLayout7.createSequentialGroup().add((Component)this.jPanel4).addContainerGap()).add(1, (GroupLayout.Group)groupLayout7.createSequentialGroup().add((Component)this.jPanel2).addContainerGap()))));
        groupLayout7.setVerticalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(1, (GroupLayout.Group)groupLayout7.createSequentialGroup().add((Component)this.jPanel4, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1).addContainerGap()));
    }

    private void alpha_valueStateChanged(ChangeEvent changeEvent) {
        if (this.slider.getSelectedIndex() >= 0) {
            Thumb<Color> thumb = this.slider.getModel().getThumbAt(this.slider.getSelectedIndex());
            int n = (Integer)this.alpha_value.getValue();
            int n2 = n * 255 / 100;
            Color color = ColorUtil.setAlpha(thumb.getObject(), n2);
            thumb.setObject(color);
            this.alpha_slider.setValue(n);
            this.slider.repaint();
        }
    }

    private void mystatechanged(ChangeEvent changeEvent) {
        if (this.slider.getSelectedIndex() >= 0) {
            Thumb<Color> thumb = this.slider.getModel().getThumbAt(this.slider.getSelectedIndex());
            thumb.setPosition((float)((Integer)this.color_location_field.getValue()).intValue() / 100.0f);
            this.slider.recalc();
            this.slider.repaint();
            this.updateFromStop(thumb);
        }
    }

    private void selectColorForThumb() {
        int n = this.slider.getSelectedIndex();
        if (n >= 0) {
            Color color = this.slider.getModel().getThumbAt(n).getObject();
            if ((color = JColorChooser.showDialog(this.slider, "Select A Color", color)) != null) {
                this.slider.getModel().getThumbAt(n).setObject(color);
                this.updateFromStop(n, this.slider.getModel().getThumbAt(n).getPosition(), color);
                this.slider.repaint();
                ((GradientPreviewPanel)this.gradientPreview).repaint();
            }
        }
    }

    public static MultipleGradientPaint showDialog(Component component, String string, MultipleGradientPaint multipleGradientPaint) {
        Component component2 = SwingUtilities.getRoot(component);
        final JDialog jDialog = new JDialog((JFrame)component2, string, true);
        GradientPicker gradientPicker = new GradientPicker();
        if (multipleGradientPaint != null) {
            gradientPicker.setGradient(multipleGradientPaint);
        }
        jDialog.add(gradientPicker);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        JButton jButton2 = new JButton("Okay");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jPanel.add(jButton);
        jPanel.add((Component)jButton2, "East");
        jDialog.add((Component)jPanel, "South");
        jDialog.pack();
        jDialog.setVisible(true);
        return gradientPicker.getGradient();
    }

    public static String toString(MultipleGradientPaint multipleGradientPaint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(multipleGradientPaint.getClass().getName());
        Color[] colorArray = multipleGradientPaint.getColors();
        float[] fArray = multipleGradientPaint.getFractions();
        stringBuffer.append("[");
        for (int i = 0; i < colorArray.length; ++i) {
            stringBuffer.append("#" + Integer.toHexString(colorArray[i].getRGB()));
            stringBuffer.append(":");
            stringBuffer.append(fArray[i]);
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GradientStyle {
        Linear,
        Radial;

    }

    private class StopListener
    implements JMultiThumbSlider.ThumbListener {
        private JMultiThumbSlider slider;

        public StopListener(JMultiThumbSlider jMultiThumbSlider) {
            this.slider = jMultiThumbSlider;
        }

        public void thumbMoved(int n, float f) {
            Color color = (Color)this.slider.getModel().getThumbAt(n).getObject();
            GradientPicker.this.updateFromStop(n, f, color);
            GradientPicker.this.updateDeleteButtons();
        }

        public void thumbSelected(int n) {
            if (n == -1) {
                GradientPicker.this.updateFromStop(-1, -1.0f, Color.black);
                return;
            }
            float f = this.slider.getModel().getThumbAt(n).getPosition();
            Color color = (Color)this.slider.getModel().getThumbAt(n).getObject();
            GradientPicker.this.updateFromStop(n, f, color);
            GradientPicker.this.updateDeleteButtons();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                GradientPicker.this.selectColorForThumb();
            }
        }
    }

    private class DeleteThumbListener
    implements ActionListener {
        JMultiThumbSlider slider;

        public DeleteThumbListener(JMultiThumbSlider jMultiThumbSlider) {
            this.slider = jMultiThumbSlider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.slider.getSelectedIndex();
            if (n >= 0) {
                this.slider.getModel().removeThumb(n);
                GradientPicker.this.updateFromStop(-1, -1.0f, null);
            }
        }
    }

    private class AddThumbListener
    implements ActionListener {
        private JMultiThumbSlider slider;

        public AddThumbListener(JMultiThumbSlider jMultiThumbSlider) {
            this.slider = jMultiThumbSlider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            float f = 0.2f;
            Color color = Color.black;
            for (int i = 0; i < this.slider.getModel().getThumbCount(); ++i) {
                float f2 = this.slider.getModel().getThumbAt(i).getPosition();
                if (f2 < f) continue;
                this.slider.getModel().insertThumb(f, color, i);
                GradientPicker.this.updateFromStop(i, f, color);
                break;
            }
        }
    }

    private class ChangeAlphaListener
    implements ChangeListener {
        private JMultiThumbSlider slider;

        public ChangeAlphaListener(JMultiThumbSlider jMultiThumbSlider) {
            this.slider = jMultiThumbSlider;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = this.slider.getSelectedIndex();
            if (n >= 0) {
                int n2 = GradientPicker.this.alpha_slider.getValue();
                Thumb<Color> thumb = this.slider.getModel().getThumbAt(n);
                Color color = (Color)thumb.getObject();
                color = ColorUtil.setAlpha(color, n2 * 255 / 100);
                thumb.setObject(color);
                GradientPicker.this.alpha_value.setValue(n2);
                this.slider.repaint();
                GradientPicker.this.gradientPreview.repaint();
            }
        }
    }

    private class ChangeColorListener
    implements ActionListener {
        private JMultiThumbSlider slider;

        public ChangeColorListener(JMultiThumbSlider jMultiThumbSlider) {
            this.slider = jMultiThumbSlider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GradientPicker.this.selectColorForThumb();
        }
    }
}

