/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfContentByte;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.javad.pdf.IContentGenerator;
import org.javad.pdf.OutputBounds;
import org.javad.pdf.PositionalContent;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.fonts.PdfFontDefinition;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.util.PdfUtil;
import org.javad.xml.XMLSerializable;

public class PageTitle
extends PositionalContent
implements XMLSerializable,
IContentGenerator {
    public static final int DASH_LENGTH = 6;
    private String title;
    private String subTitle;
    private String classifier;

    public PageTitle(PageConfiguration configuration) {
        super(configuration);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Override
    public OutputBounds generate(PdfContentByte content) {
        int maxWidth = 0;
        content.setColorStroke(BaseColor.BLACK);
        Font f = FontRegistry.getInstance().getFont(PdfFontDefinition.Title);
        content.setFontAndSize(f.getBaseFont(), f.getSize());
        float top = this.getY();
        content.setHorizontalScaling(110.0f);
        if (this.getTitle() != null && !this.getTitle().isEmpty()) {
            String[] _title = PdfUtil.toUpperCase(this.getTitle()).split("\n");
            int t_count = 0;
            for (String theTitle : _title) {
                maxWidth = (int)f.getBaseFont().getWidthPoint(theTitle, f.getSize());
                PdfUtil.renderConstrainedText(content, theTitle, f, this.getX(), top, (int)((double)maxWidth * 1.1));
                top -= ++t_count < _title.length ? f.getCalculatedSize() + 2.0f : 0.0f;
            }
        }
        if (this.getSubTitle() != null && !this.getSubTitle().isEmpty()) {
            Font subFont = FontRegistry.getInstance().getFont(PdfFontDefinition.Subtitle);
            top -= subFont.getCalculatedSize() + PdfUtil.convertFromMillimeters(3.0f);
            content.setFontAndSize(subFont.getBaseFont(), subFont.getSize());
            String[] _subtitle = PdfUtil.toUpperCase(this.getSubTitle()).split("\n");
            int count = 0;
            for (String sTitle : _subtitle) {
                maxWidth = Math.max(maxWidth, (int)subFont.getBaseFont().getWidthPoint(sTitle, subFont.getSize()));
                PdfUtil.renderConstrainedText(content, sTitle, subFont, this.getX(), top, (int)((double)maxWidth * 1.1));
                top -= ++count < _subtitle.length ? subFont.getCalculatedSize() + 2.0f : 0.0f;
            }
        }
        content.setHorizontalScaling(100.0f);
        if (this.getClassifier() != null && !this.getClassifier().isEmpty()) {
            Font classFont = FontRegistry.getInstance().getFont(PdfFontDefinition.Classifier);
            content.setFontAndSize(classFont.getBaseFont(), classFont.getSize());
            float width = classFont.getBaseFont().getWidthPoint(this.getClassifier(), classFont.getCalculatedSize()) + 4.0f;
            maxWidth = Math.max(maxWidth, (int)width + 12);
            content.setLineWidth(0.8f);
            float lineTop = (top -= classFont.getCalculatedSize() + PdfUtil.convertFromMillimeters(3.0f)) + (float)((int)classFont.getSize() / 2 - 1);
            content.moveTo(this.getX() - width / 2.0f - 6.0f, lineTop);
            content.lineTo(this.getX() - width / 2.0f, lineTop);
            content.moveTo(this.getX() + width / 2.0f, lineTop);
            content.lineTo(this.getX() + width / 2.0f + 6.0f, lineTop);
            content.stroke();
            PdfUtil.renderConstrainedText(content, this.getClassifier(), classFont, this.getX(), top, (int)((double)maxWidth * 1.1));
        }
        OutputBounds rect = new OutputBounds(this.getX() - (float)(maxWidth / 2), this.getY(), maxWidth, this.getY() - top);
        return rect;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("title:      ").append(this.title);
        if (this.subTitle != null) {
            buf.append("\nsubtitle:   ").append(this.subTitle);
        }
        if (this.classifier != null) {
            buf.append("\nclassifier: ").append(this.classifier);
        }
        return buf.toString();
    }

    @Override
    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        if (this.getTitle() != null) {
            writer.writeAttribute("title", this.getTitle());
        }
        if (this.getSubTitle() != null) {
            writer.writeAttribute("subtitle", this.getSubTitle());
        }
        if (this.getClassifier() != null) {
            writer.writeAttribute("classifier", this.getClassifier());
        }
    }
}

