/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.fonts;

import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.BaseFont;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.javad.pdf.fonts.PdfFontBean;
import org.javad.pdf.fonts.PdfFontDefinition;
import org.javad.pdf.fonts.PdfFontMapping;

public class FontRegistry {
    public static final String PREFERENCE_USAGE = "usage";
    public static final String PREFERENCE_MAPPING = "mapping";
    public static final String FILE_FONTPATH = "file.fontPath";
    private static final Logger logger = Logger.getLogger(FontRegistry.class.getName());
    private static FontRegistry factory = null;
    private Map<PdfFontDefinition, PdfFontBean> fontMap = null;
    private Collection<PdfFontMapping> fontMappings = null;
    private final Map<PdfFontBean, Font> calculatedFonts = new HashMap<PdfFontBean, Font>();
    private String fontPath;
    private boolean registered = false;

    protected FontRegistry() {
    }

    public static FontRegistry getInstance() {
        if (factory == null) {
            factory = new FontRegistry();
        }
        return factory;
    }

    public static Preferences getPreferencesNode() {
        return Preferences.userNodeForPackage(FontRegistry.class);
    }

    public void register() {
        this.registered = false;
    }

    public void initializeFontPath() {
        Preferences prefs = FontRegistry.getPreferencesNode();
        String path = prefs.get(FILE_FONTPATH, null);
        this.setFontPath(path);
    }

    public void initializeFonts() {
        if (!this.registered) {
            String path = this.getFontPath();
            if (path != null) {
                FontFactory.registerDirectory(path, true);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(FontFactory.getRegisteredFonts().toString());
                }
            }
            this.registered = true;
        }
    }

    protected void initializeFontTable() {
        if (this.fontMap != null && !this.fontMap.isEmpty()) {
            return;
        }
        this.fontMap = new HashMap<PdfFontDefinition, PdfFontBean>();
        this.calculatedFonts.clear();
        Preferences prefs = FontRegistry.getPreferencesNode();
        try {
            Preferences bean = prefs.node(PREFERENCE_USAGE);
            for (PdfFontDefinition usage : PdfFontDefinition.values()) {
                PdfFontBean b;
                String value = bean.get(usage.toString(), null);
                if (value != null) {
                    b = PdfFontBean.fromString(value);
                    b.setFontDefinition(usage);
                } else {
                    b = new PdfFontBean();
                    b.setFontDefinition(usage);
                    b.setSize(usage.getDefaultSize());
                    b.setFontFamily(usage.getDefaultTypeFace());
                    b.setStyle(usage.getDefaultStyle());
                    b.setSystem(true);
                }
                if (usage == PdfFontDefinition.ExtendedCharacters) {
                    logger.log(Level.INFO, "Extended Character font is to " + b.getFontFamily());
                    b.setI18N(true);
                }
                this.fontMap.put(b.getFontDefinition(), b);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "There was an issue reading the font usages:", e);
        }
    }

    public Collection<PdfFontMapping> getFontMappings() {
        if (this.fontMappings != null) {
            return this.fontMappings;
        }
        this.fontMappings = new ArrayList<PdfFontMapping>();
        Preferences prefs = FontRegistry.getPreferencesNode();
        try {
            Preferences mapping = prefs.node(PREFERENCE_MAPPING);
            for (String alias : mapping.keys()) {
                PdfFontMapping ref = new PdfFontMapping();
                ref.setFontAlias(alias);
                ref.setFilePath(mapping.get(alias, null));
                this.fontMappings.add(ref);
            }
        }
        catch (BackingStoreException e) {
            logger.log(Level.FINE, "There was an issue reading the font mappings: ", e);
        }
        return this.fontMappings;
    }

    public Collection<PdfFontBean> getFontBeans() {
        this.initializeFontTable();
        ArrayList<PdfFontBean> beans = new ArrayList<PdfFontBean>(this.fontMap.values());
        Collections.sort(beans);
        return beans;
    }

    public void setFontBeans(Collection<PdfFontBean> beans) {
        Preferences prefs = FontRegistry.getPreferencesNode();
        try {
            if (prefs.nodeExists(PREFERENCE_USAGE)) {
                Preferences mapping = prefs.node(PREFERENCE_USAGE);
                mapping.removeNode();
                prefs.flush();
                mapping = prefs.node(PREFERENCE_USAGE);
                if (beans != null) {
                    for (PdfFontBean ref : beans) {
                        mapping.put(ref.getFontDefinition().toString(), ref.asString());
                    }
                }
                prefs.flush();
                this.fontMap = null;
            }
        }
        catch (BackingStoreException e) {
            logger.log(Level.FINE, "There is an issue saving the font bean: ", e);
        }
    }

    public void setFontMappings(Collection<PdfFontMapping> references) {
        Preferences prefs = FontRegistry.getPreferencesNode();
        try {
            if (prefs.nodeExists(PREFERENCE_MAPPING)) {
                Preferences mapping = prefs.node(PREFERENCE_MAPPING);
                mapping.removeNode();
                prefs.flush();
                mapping = prefs.node(PREFERENCE_MAPPING);
                if (references != null) {
                    for (PdfFontMapping ref : references) {
                        mapping.put(ref.getFontAlias(), ref.getFilePath());
                    }
                }
                prefs.flush();
                this.fontMappings = null;
            }
        }
        catch (BackingStoreException e) {
            logger.log(Level.FINE, "There is an issue saving the font mappings: ", e);
        }
    }

    public void setFontPath(String fontPath) {
        this.fontPath = fontPath;
        this.registered = false;
    }

    public String getFontPath() {
        if (this.fontPath == null) {
            logger.info("No font path is set.  Attempting to determine system font path.");
            this.fontPath = this.getNativeFontPath();
        }
        return this.fontPath;
    }

    protected String getNativeFontPath() {
        String path = null;
        String operating_system = System.getProperty("os.name");
        path = operating_system != null && operating_system.toLowerCase().contains("windows") ? "c:\\Windows\\Fonts" : System.getenv("JAVA_FONTS");
        try {
            Method m;
            Class<?> clazz = Class.forName("sun.font.FontManager");
            if (clazz != null && (m = clazz.getDeclaredMethod("getFontPath", Boolean.TYPE)) != null) {
                path = m.invoke(null, true).toString();
            }
        }
        catch (Exception t) {
            logger.info("Non Oracle Java VM detected.  No font path is available.");
        }
        logger.log(Level.FINE, "Calculated system font path is \"{0}\"", path);
        return path;
    }

    public Font getFont(PdfFontDefinition name) {
        Font f = null;
        this.initializeFontTable();
        PdfFontBean bean = this.fontMap.get((Object)name);
        if (bean == null) {
            throw new IllegalArgumentException("The name \"" + name.toString() + "\" was not found in the mapping.");
        }
        if (this.calculatedFonts.containsKey(bean)) {
            return this.calculatedFonts.get(bean);
        }
        if (bean.isSystem()) {
            this.initializeFonts();
            f = this.findFont(bean.getFontFamily(), bean);
        } else if (bean.getFontMapping() != null) {
            logger.log(Level.FINE, "Using a mapped font for \"{0}\"", (Object)name);
            PdfFontMapping mapping = bean.getFontMapping();
            FontFactory.register(mapping.getFilePath(), mapping.getFontAlias());
            f = this.findFont(mapping.getFontAlias(), bean);
        }
        if (this.isFontInvalid(f)) {
            logger.log(Level.INFO, "Unable to find a registered font for \"{0}\" using default of Helvetica", (Object)name);
            f = FontFactory.getFont("Helvetica", name.getDefaultSize(), name.getDefaultStyle());
        }
        this.calculatedFonts.put(bean, f);
        return f;
    }

    Font findFont(String name, PdfFontBean bean) {
        String form = bean.isI18N() ? "Identity-H" : "Cp1252";
        Font f = null;
        if (bean.isBold() && bean.isItalic()) {
            f = FontFactory.getFont(name + "-bolditalic", form, bean.getSize(), bean.getStyle());
        }
        if (this.isFontInvalid(f) && bean.isBold()) {
            f = FontFactory.getFont(name + " bold", form, bean.getSize(), bean.getStyle());
        }
        if (this.isFontInvalid(f) && bean.isItalic() && this.isFontInvalid(f = FontFactory.getFont(name + " italic", form, bean.getSize(), bean.getStyle()))) {
            f = FontFactory.getFont(name + "-italic", form, bean.getSize(), bean.getStyle());
        }
        if (this.isFontInvalid(f)) {
            f = FontFactory.getFont(name, form, bean.getSize(), bean.getStyle());
        }
        if (logger.isLoggable(Level.FINER)) {
            BaseFont bf = f.getBaseFont();
            if (bf != null) {
                String[][] fullName = bf.getFullFontName();
                if (fullName != null && fullName.length >= 1 && fullName[0].length >= 4) {
                    logger.log(Level.FINER, "The calculated font name is \"{0}\"", fullName[0][3]);
                } else {
                    logger.finer("The base font full name was not parseable.");
                }
            } else {
                logger.log(Level.FINER, "The base font was null for \"{0}\" with style {1}", new Object[]{name, bean.getStyle()});
            }
        }
        return f;
    }

    private boolean isFontInvalid(Font f) {
        return f == null || f != null && f.getBaseFont() == null;
    }
}

