/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.javad.pdf.model.PageConfiguration;
import org.javad.stamp.pdf.Resources;

public class PageConfigurations {
    private Map<String, PageConfiguration> configurations = new HashMap<String, PageConfiguration>();
    private String defaultConfiguration;
    private String activeConfiguration;
    private boolean loaded = false;
    private static final Logger logger = Logger.getLogger(PageConfigurations.class.getName());
    private static PageConfigurations instance = null;
    public static final String PAGE_CONFIGURATION = "page.configuration";
    public static final String DEFAULT_CONFIGURATION = "page.configuration.default";
    private List<PageConfigurationChangeHandler> handlers = new ArrayList<PageConfigurationChangeHandler>();

    protected PageConfigurations() {
    }

    public void addPageConfigurationChangeHandler(PageConfigurationChangeHandler handler) {
        this.handlers.add(handler);
    }

    public static PageConfigurations getInstance() {
        if (instance == null) {
            instance = new PageConfigurations();
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    public void load() {
        if (!this.loaded) {
            try {
                void var7_11;
                Properties properties = new Properties();
                InputStream in = this.getClass().getResourceAsStream("/META-INF/settings.xml");
                properties.loadFromXML(in);
                HashSet<Object> configKeys = new HashSet<Object>();
                String keys = properties.getProperty(PAGE_CONFIGURATION, "lighthouse");
                String[] stringArray = keys.split(",");
                int n = stringArray.length;
                boolean bl = false;
                while (var7_11 < n) {
                    String k = stringArray[var7_11];
                    configKeys.add(k);
                    ++var7_11;
                }
                Preferences root = Resources.getPreferencesNode();
                try {
                    for (String k : root.childrenNames()) {
                        configKeys.add(k);
                    }
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
                for (String string : configKeys) {
                    PageConfiguration configuration = new PageConfiguration(string);
                    configuration.load();
                    logger.info("Reading configuration for \"" + configuration.getDisplayName() + "\"...");
                    this.configurations.put(string, configuration);
                }
                this.defaultConfiguration = properties.getProperty(DEFAULT_CONFIGURATION);
                this.loaded = true;
            }
            catch (IOException ie) {
                logger.log(Level.SEVERE, "Unable to load the master configuration", ie);
            }
        }
    }

    public void load(PageConfiguration config) {
        config.load();
        for (PageConfigurationChangeHandler handler : this.handlers) {
            handler.onPageConfigurationChanged(PageConfigurationChangeType.LOAD, config);
        }
    }

    public void delete(PageConfiguration config) {
        if (config.isSystemConfiguration()) {
            logger.warning("Deletion of system configuration \"" + config.getDisplayName() + "\" is not supported.");
        } else {
            Preferences prefs = Resources.getPreferencesNode();
            try {
                prefs.node(config.getName()).removeNode();
                Resources.getPreferencesNode().remove(config.getName());
                logger.info("Removed configuration \"" + config.getDisplayName() + "\"");
            }
            catch (BackingStoreException e) {
                logger.log(Level.SEVERE, "Unable to remove configuration with name \"" + config.getName() + "\"");
            }
        }
        for (PageConfigurationChangeHandler handler : this.handlers) {
            handler.onPageConfigurationChanged(PageConfigurationChangeType.DELETE, config);
        }
    }

    public void save(PageConfiguration config) {
        config.save();
        for (PageConfigurationChangeHandler handler : this.handlers) {
            handler.onPageConfigurationChanged(PageConfigurationChangeType.SAVE, config);
        }
    }

    public void create(PageConfiguration config) {
        config.save();
        this.configurations.put(config.getName(), config);
        for (PageConfigurationChangeHandler handler : this.handlers) {
            handler.onPageConfigurationChanged(PageConfigurationChangeType.CREATE, config);
        }
    }

    public void revertAll() {
        for (PageConfiguration config : this.configurations.values()) {
            if (config.isSystemConfiguration()) {
                config.revert();
                continue;
            }
            this.delete(config);
        }
    }

    public void revert(PageConfiguration config) {
        config.revert();
        for (PageConfigurationChangeHandler handler : this.handlers) {
            handler.onPageConfigurationChanged(PageConfigurationChangeType.REVERT, config);
        }
    }

    public void setActiveConfiguration(String activeConfiguration) {
        if (!this.configurations.containsKey(activeConfiguration)) {
            throw new IllegalArgumentException("The active configuration was not valid.");
        }
        this.activeConfiguration = activeConfiguration;
    }

    public PageConfiguration getActiveConfiguration() {
        if (!this.loaded) {
            this.load();
        }
        String name = this.activeConfiguration != null ? this.activeConfiguration : this.defaultConfiguration;
        return this.getConfiguration(name);
    }

    public PageConfiguration getConfiguration(String configuration) {
        if (!this.loaded) {
            this.load();
        }
        if (configuration != null) {
            return this.configurations.get(configuration);
        }
        logger.fine("No configuration was found.");
        return null;
    }

    public List<PageConfiguration> getConfigurations() {
        if (!this.loaded) {
            this.load();
        }
        ArrayList<PageConfiguration> configs = new ArrayList<PageConfiguration>();
        for (PageConfiguration config : this.configurations.values()) {
            configs.add(config);
        }
        return configs;
    }

    public static interface PageConfigurationChangeHandler {
        public void onPageConfigurationChanged(PageConfigurationChangeType var1, PageConfiguration var2);
    }

    public static enum PageConfigurationChangeType {
        SAVE,
        CREATE,
        LOAD,
        DELETE,
        REVERT;

    }
}

