/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.javad.pdf.IContentGenerator;
import org.javad.pdf.OutputBounds;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.fonts.PdfFontDefinition;

public class PdfUtil {
    public static float DPI = 72.0f;
    public static float MM_INCH = 25.4f;
    private static long LAST_CHECK_TIME = 0L;
    private static BaseFont i18Font;
    private static final Map<String, String> UPPERCASE_REPLACEMENTS;

    public static float convertFromMillimeters(float mm) {
        return mm / MM_INCH * DPI;
    }

    public static float convertFromDPI(float dpi) {
        return dpi / DPI * MM_INCH;
    }

    public static boolean isTextTooWide(String text, Font f, float width) {
        return f.getBaseFont().getWidthPoint(text, f.getSize()) > width;
    }

    public static String convertToProperCase(String s) {
        StringBuilder buf = new StringBuilder(s.length());
        StringTokenizer t = new StringTokenizer(s, " ", true);
        while (t.hasMoreTokens()) {
            String remainder;
            String token = t.nextToken();
            String string = remainder = token.length() > 1 ? token.substring(1).toLowerCase() : token;
            if (token.length() > 1) {
                buf.append(("" + token.charAt(0)).toUpperCase());
            }
            buf.append(remainder);
        }
        return buf.toString();
    }

    public static boolean isIssueText(String s) {
        boolean valid;
        boolean bl = valid = s != null && !s.isEmpty();
        if (valid) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (Character.isDigit(c) || c == '-') continue;
                valid = false;
            }
        }
        return valid;
    }

    public static float convertToStampBoxWidth(int width) {
        return PdfUtil.convertFromMillimeters(width) * 0.95f;
    }

    public static String toUpperCase(String s) {
        String str = s;
        for (String key : UPPERCASE_REPLACEMENTS.keySet()) {
            str = str.replace(key, UPPERCASE_REPLACEMENTS.get(key));
        }
        str = str.toUpperCase();
        for (String key : UPPERCASE_REPLACEMENTS.keySet()) {
            str = str.replace(UPPERCASE_REPLACEMENTS.get(key), key);
        }
        return str;
    }

    public static float renderConstrainedText(PdfContentByte content, String text, Font f, float x, float y, int width) {
        float offset = 0.0f;
        if (text == null || text.isEmpty()) {
            return offset;
        }
        float w = PdfUtil.convertToStampBoxWidth(width);
        String prevStr = "";
        text = text.replace("\\n", "\n");
        for (String v : text.split("\n")) {
            String str = "";
            for (String s : v.split(" ")) {
                if (PdfUtil.isTextTooWide(str = str + (!str.isEmpty() ? " " : "") + s, f, w)) {
                    PdfUtil.improveRenderText(content, prevStr, f, x, y + offset);
                    offset -= f.getSize() + 1.0f;
                    prevStr = s;
                    str = s;
                    continue;
                }
                prevStr = str;
            }
            if (str.isEmpty()) continue;
            PdfUtil.improveRenderText(content, prevStr, f, x, y + offset);
            offset -= f.getSize() + 1.0f;
        }
        return offset;
    }

    protected static void improveRenderText(PdfContentByte content, String str, Font f, float x, float y) {
        BaseFont lastFont;
        BaseFont bf = f.getCalculatedBaseFont(false);
        if (i18Font == null && System.currentTimeMillis() - LAST_CHECK_TIME > 10000L) {
            i18Font = FontRegistry.getInstance().getFont(PdfFontDefinition.ExtendedCharacters).getCalculatedBaseFont(false);
            LAST_CHECK_TIME = System.currentTimeMillis();
        }
        StringBuilder buf = new StringBuilder(str.length());
        boolean extendedCodePoint = false;
        float effWidth = 0.0f;
        for (int i = 0; i < str.length(); ++i) {
            boolean curCodePoint;
            char c = str.charAt(i);
            int codePoint = Character.codePointAt("" + c, 0);
            boolean bl = curCodePoint = !bf.charExists(codePoint);
            if (curCodePoint != extendedCodePoint) {
                content.setFontAndSize(extendedCodePoint ? i18Font : bf, f.getSize());
                effWidth += content.getEffectiveStringWidth(buf.toString(), false);
                buf = new StringBuilder();
                extendedCodePoint = curCodePoint;
            }
            buf.append(c);
        }
        content.setFontAndSize(bf, f.getSize());
        float x_pos = x - (effWidth += content.getEffectiveStringWidth(buf.toString(), false)) / 2.0f;
        content.beginText();
        content.setTextMatrix(x_pos, y);
        BaseFont currentFont = lastFont = bf;
        buf = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int codePoint = Character.codePointAt("" + c, 0);
            currentFont = !bf.charExists(codePoint) ? i18Font : bf;
            if (currentFont != lastFont) {
                content.showText(buf.toString());
                buf = new StringBuilder();
                content.setFontAndSize(currentFont, f.getSize());
                lastFont = currentFont;
            }
            buf.append(c);
        }
        if (buf.length() > 0) {
            content.showText(buf.toString());
        }
        content.endText();
    }

    public static int getDescriptionTextRowsForStampBox(PdfContentByte content, Font f, Font secondary_f, String description, String secondary_description, int width) {
        int rows = 0;
        try {
            Document d = new Document(content.getPdfDocument().getPageSize());
            PdfWriter writer = PdfWriter.getInstance(d, new ByteArrayOutputStream());
            d.open();
            PdfContentByte c = writer.getDirectContent();
            float top = 0.0f;
            float d_delta = PdfUtil.renderConstrainedText(c, description, f, 0.0f, top, width);
            rows += (int)Math.ceil(d_delta / f.getCalculatedSize());
            float delta = PdfUtil.renderConstrainedText(c, secondary_description, secondary_f, 0.0f, top += d_delta, width);
            if (delta < 1.0f) {
                rows += (int)Math.ceil(delta / f.getCalculatedSize());
            }
            if (rows > -3 && d_delta >= -1.0f * (f.getSize() + 1.0f)) {
                --rows;
            }
            c.lineTo(1.0f, 1.0f);
            d.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return -1 * rows;
    }

    public static float findMaximumWidth(IContentGenerator generator, PdfContentByte content) {
        float width = 0.0f;
        try {
            Document d = new Document(content.getPdfDocument().getPageSize());
            PdfWriter writer = PdfWriter.getInstance(d, new ByteArrayOutputStream());
            d.open();
            PdfContentByte c = writer.getDirectContent();
            OutputBounds bounds = generator.generate(c);
            width = bounds.width;
            d.newPage();
            d.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return width;
    }

    static {
        UPPERCASE_REPLACEMENTS = new HashMap<String, String>();
        UPPERCASE_REPLACEMENTS.put("\u00df", "\u1e9e");
    }

    private static class ReplacementRecord {
        int position;
        char character;

        private ReplacementRecord() {
        }
    }
}

