/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.htmlparser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javad.pdf.util.PdfUtil;

public class HtmlHelper {
    public static final Pattern NUMBERS = Pattern.compile("^([-+]?[0-9]*\\.?[0-9]*)+");
    public static float W_RATIO = 3.73913f;
    public static float PT_RATIO = 2.815f;
    public static float INCH_RATIO = 25.4f;
    private static final String[][] modifiers = new String[][]{{" On ", " on "}, {" Of ", " of "}, {" And ", " and "}, {" Over ", " over "}, {" In ", " in "}, {" By ", " by "}, {" With ", " with "}, {" Without ", " without "}, {" The ", " the "}, {"&amp;", "and"}, {"&nbsp;", ""}, {"&quot;", "'"}, {"\"", "'"}};
    private static final String[][] currencyConversion = new String[][]{{"p", "d"}, {"sh", "/"}};
    private static final char[] currencyPrefixes = new char[]{'$', '\u00a3', '\u00a5', '\u20ac'};

    public static boolean startsWithCurrency(String text) {
        if (text != null && !text.isEmpty()) {
            for (char c : currencyPrefixes) {
                if (c != text.charAt(0)) continue;
                return true;
            }
        }
        return false;
    }

    public static String normalizeDenomination(String text) {
        String[] parts = text.split(" ");
        StringBuilder buf = new StringBuilder(text.length());
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            String number = HtmlHelper.retrieveNumber(part, true);
            if (!part.isEmpty() && (Character.isDigit(part.charAt(0)) || part.charAt(0) == '\u00bd' || part.charAt(0) == '\u00bc' || part.charAt(0) == '\u00be') && number.length() < part.length()) {
                String unit = part.substring(number.length()).toLowerCase();
                for (String[] currency : currencyConversion) {
                    if (!unit.endsWith(currency[0])) continue;
                    unit = unit.replace(currency[0], currency[1]);
                }
                part = number + unit;
            }
            buf.append(part);
            if (i >= parts.length - 1) continue;
            buf.append(' ');
        }
        String val = buf.toString();
        if (val.length() > 0) {
            val = val.replace("/ ", "/-");
        }
        return val;
    }

    public static String retrieveNumber(String text, boolean notConvertible) {
        String number = "";
        for (int i = 0; i < text.length(); ++i) {
            try {
                String val = number + text.charAt(i);
                Float.valueOf(val);
                number = val;
                continue;
            }
            catch (NumberFormatException nfe) {
                if ((!notConvertible || text.charAt(i) != '\u00bd') && text.charAt(i) != '\u00bc' && text.charAt(i) != '\u00be') break;
                number = number + text.charAt(i);
                break;
            }
        }
        return number;
    }

    public static String normalizeText(String text) {
        String s = text.replace("\r", "");
        s = s.replace("\u00a0", "");
        s = s.replace("\n", "");
        s = s.replace("  ", " ");
        s = s.replace("  ", " ");
        return s;
    }

    public static String normalizeTitle(String text) {
        return HtmlHelper.normalizeText(text);
    }

    public static String normalizeBoxText(String text) {
        String s = HtmlHelper.normalizeText(text);
        s = PdfUtil.convertToProperCase(s);
        for (String[] modifier : modifiers) {
            if (!s.contains(modifier[0])) continue;
            s = s.replace(modifier[0], modifier[1]);
        }
        return s;
    }

    public static float convertToNumber(String value) {
        Matcher matcher;
        if (value != null && (matcher = NUMBERS.matcher(value.trim())).find()) {
            float f = Float.valueOf(matcher.group(0)).floatValue();
            if (value.endsWith("in")) {
                f *= INCH_RATIO;
            } else if (value.endsWith("pt")) {
                f /= PT_RATIO;
            }
            return f;
        }
        return -1.0f;
    }

    public static String extractValueFromStyle(String style, String key) {
        String val = null;
        int index = style.indexOf(key + ":");
        if (index < 0) {
            return val;
        }
        String[] styles = style.substring(index + (key.length() + 1)).split(";");
        if (styles.length > 0) {
            val = styles[0];
        }
        return val;
    }
}

