/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.htmlparser.msword;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.htmlparser.Node;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.javad.stamp.htmlparser.msword.matchers.NodeMatcher;

public class NodeListProcessor {
    public Node findParent(Node n, NodeMatcher matcher) {
        Node parent = null;
        Node p = n.getParent();
        if (p != null) {
            if (matcher.matches(p)) {
                parent = p;
            } else {
                try {
                    NodeList validChildren = this.findChildren(p.getChildren(), matcher);
                    parent = validChildren.size() > 0 ? validChildren.elementAt(0) : this.findParent(p, matcher);
                }
                catch (ParserException ex) {
                    Logger.getLogger(NodeListProcessor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return parent;
    }

    public Node findParentByTagName(Node n, String tag) {
        Node p = n.getParent();
        if (p != null && p instanceof TagNode) {
            TagNode tn = (TagNode)p;
            if (tn.getTagName().equalsIgnoreCase(tag)) {
                return p;
            }
            p = this.findParentByTagName(p, tag);
        }
        return p;
    }

    public Node findPredecessorSibling(Node n) {
        Node parent = n.getParent();
        if (parent != null && n instanceof TagNode) {
            TagNode tag = (TagNode)n;
            NodeList list = parent.getChildren();
            int index = list.indexOf(n);
            if (index >= 0) {
                for (int i = index - 1; i >= 0; --i) {
                    Node c = list.elementAt(i);
                    if (!(c instanceof TagNode)) continue;
                    TagNode tn = (TagNode)c;
                    if (!tag.getTagName().equals(tn.getTagName())) continue;
                    return c;
                }
            }
        }
        return null;
    }

    public NodeList findChildrenByTagName(Node n, String tagName) {
        NodeList list = new NodeList();
        NodeList children = n.getChildren();
        if (children != null) {
            Node child;
            int i;
            for (i = 0; i < children.size(); ++i) {
                TagNode node;
                child = children.elementAt(i);
                if (!(child instanceof TagNode) || !(node = (TagNode)child).getTagName().equalsIgnoreCase(tagName)) continue;
                list.add((Node)node);
            }
            if (children.size() > 0 && list.size() == 0) {
                for (i = 0; i < children.size(); ++i) {
                    child = children.elementAt(i);
                    list.add(this.findChildrenByTagName(child, tagName));
                }
            }
        }
        return list;
    }

    public NodeList findChildren(NodeList n, NodeMatcher matcher) throws ParserException {
        return this.findChildren(n, matcher, false);
    }

    public NodeList findChildren(NodeList n, NodeMatcher matcher, boolean fullDepth) throws ParserException {
        NodeList list = new NodeList();
        if (n != null) {
            SimpleNodeIterator iter = n.elements();
            while (iter.hasMoreNodes()) {
                NodeList result;
                Node node = iter.nextNode();
                if (matcher.matches(node)) {
                    list.add(node);
                    if (!fullDepth) continue;
                }
                if ((result = this.findChildren(node.getChildren(), matcher, fullDepth)).size() <= 0) continue;
                list.add(result);
            }
        }
        return list;
    }
}

