/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.htmlparser.msword;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.htmlparser.Node;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.tags.ParagraphTag;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.javad.pdf.ISetContent;
import org.javad.stamp.htmlparser.HtmlHelper;
import org.javad.stamp.htmlparser.msword.AbstractProcessor;
import org.javad.stamp.htmlparser.msword.StampRowProcessor;
import org.javad.stamp.htmlparser.msword.matchers.TextNodeMatcher;
import org.javad.stamp.htmlparser.msword.styles.ComponentType;
import org.javad.stamp.htmlparser.msword.styles.MatcherFactory;
import org.javad.stamp.htmlparser.msword.styles.PageStyle;
import org.javad.stamp.pdf.StampSet;

public class StampSetProcessor
extends AbstractProcessor<StampSet> {
    private final MatcherFactory factory;

    public StampSetProcessor(PageStyle style) {
        super(style);
        this.factory = MatcherFactory.getInstance(style);
    }

    @Override
    public StampSet process(Node stampSet, Node page) {
        StampSet set = new StampSet(this.getPageConfiguration());
        StampRowProcessor rowProcessor = new StampRowProcessor(this.getPageStyle());
        NodeList rows = this.getNodeListProcessor().findChildrenByTagName(stampSet, "TR");
        for (int i = 0; i < rows.size(); ++i) {
            Node rowNode = rows.elementAt(i);
            ISetContent content = rowProcessor.process(rowNode, page);
            set.addContentRow(content);
        }
        Node previous = this.getNodeListProcessor().findParentByTagName(stampSet, "TD");
        if (previous != null) {
            StringBuilder buf = new StringBuilder();
            try {
                NodeList children = previous.getChildren();
                NodeList matchedChildren = this.getNodeListProcessor().findChildren(children, this.factory.getMatcher(ComponentType.SetDescription));
                if (matchedChildren != null && matchedChildren.size() > 0) {
                    int i;
                    int tableIndex = children.indexOf(stampSet);
                    int startingIndex = 0;
                    for (i = 0; i < tableIndex; ++i) {
                        if (!(children.elementAt(i) instanceof TableTag)) continue;
                        startingIndex = i;
                    }
                    for (i = startingIndex; i < tableIndex; ++i) {
                        Node n = children.elementAt(i);
                        if (!matchedChildren.contains(n) || !(n instanceof ParagraphTag)) continue;
                        ParagraphTag p = (ParagraphTag)n;
                        NodeList text = this.getNodeListProcessor().findChildren(p.getChildren(), new TextNodeMatcher());
                        SimpleNodeIterator iter = text.elements();
                        while (iter.hasMoreNodes()) {
                            if (buf.length() > 0) {
                                buf.append(' ');
                            }
                            buf.append(((TextNode)iter.nextNode()).getText());
                        }
                    }
                }
            }
            catch (ParserException ex) {
                Logger.getLogger(StampSetProcessor.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.processDescription(set, buf.toString());
        }
        return set;
    }

    private void processDescription(StampSet set, String str) {
        int indx;
        String[] tokens = str.split(" ");
        if (tokens.length > 0) {
            String issueText = tokens[tokens.length - 1];
            boolean valid = true;
            for (int i = 0; i < issueText.length(); ++i) {
                char c = issueText.charAt(i);
                if (Character.isDigit(c) || c == '-' || c == ',') continue;
                valid = false;
            }
            if (valid && issueText.length() >= 4) {
                set.setIssue(issueText);
                str = str.substring(0, Math.max(str.length() - issueText.length() - 1, 0));
            }
        }
        if ((indx = (str = HtmlHelper.normalizeBoxText(str)).indexOf("Watermark")) < 0) {
            indx = str.indexOf("Unwatermark");
        }
        if (indx >= 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(str.substring(0, indx));
            buf.append("\\n");
            buf.append(str.substring(indx));
            str = buf.toString();
        }
        set.setDescription(str);
    }
}

