/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.javad.events.StatusEvent;
import org.javad.pdf.ISetContent;
import org.javad.pdf.OutputBounds;
import org.javad.pdf.Page;
import org.javad.pdf.PageTitle;
import org.javad.pdf.TitlePage;
import org.javad.pdf.TitlePageContent;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.model.PageConfigurations;
import org.javad.pdf.util.PdfUtil;
import org.javad.stamp.pdf.ColumnSet;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.ui.model.GenerateBean;
import org.javad.stamp.xml.StampXMLParserFactory;
import org.javad.xml.XMLSerializable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PdfGenerator {
    StampXMLParserFactory factory = null;
    private boolean debug = false;
    private PageConfiguration config;
    private static final Logger logger = Logger.getLogger(PdfGenerator.class.getName());

    public PdfGenerator() {
        try {
            PageConfigurations configs = PageConfigurations.getInstance();
            this.config = configs.getActiveConfiguration();
            this.factory = StampXMLParserFactory.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            throw new IllegalArgumentException("The source and target files are required.");
        }
        PdfGenerator generator = new PdfGenerator();
        try {
            if (args.length >= 3 && args[2].equalsIgnoreCase("-debug")) {
                generator.setDebug(true);
            }
            generator.generate(new GenerateBean(new File(args[0]), new File(args[1])));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void createPage(PdfWriter writer, float center, PageTitle title, ISetContent ... sets) {
        PdfContentByte handler = writer.getDirectContent();
        title.setX(center);
        title.setY((int)PdfUtil.convertFromMillimeters(this.config.getHeight() - this.config.getMarginTop() - 15.0f));
        OutputBounds rect = title.generate(handler);
        boolean previousTextOnly = false;
        for (ISetContent set : sets) {
            if (set instanceof ColumnSet) {
                float width = PdfUtil.findMaximumWidth(set, handler);
                set.setX(center - width / 2.0f);
            } else {
                set.setX(center);
            }
            set.setY(rect.y - rect.height - (!previousTextOnly ? PdfUtil.convertFromMillimeters(5.0f) : 0.0f));
            rect = set.generate(handler);
            previousTextOnly = set.isTextOnly();
        }
    }

    public void createTitlePage(PdfWriter writer, float center, TitlePageContent title) {
        PdfContentByte handler = writer.getDirectContent();
        title.setX(center);
        title.setY((int)PdfUtil.convertFromMillimeters(this.config.getHeight() - this.config.getMarginTop() - 15.0f));
        title.generate(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(GenerateBean bean) throws Exception {
        long t = System.currentTimeMillis();
        this.config.parseSkipTerms(bean.getTags());
        Rectangle rect = new Rectangle(PdfUtil.convertFromMillimeters(this.config.getWidth()), PdfUtil.convertFromMillimeters(this.config.getHeight()));
        Document document = new Document(rect);
        PdfWriter writer = null;
        FileOutputStream fos = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            boolean validName = bean.getInputFile().getName().toLowerCase().endsWith(".xml");
            writer = PdfWriter.getInstance(document, baos);
            if (validName) {
                this.setMargins(document);
                this.parseXMLDocument(bean, document, writer);
                baos.flush();
                fos = new FileOutputStream(bean.getOutputFile());
                fos.write(baos.toByteArray());
                fos.flush();
                baos.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            baos.close();
            if (writer != null) {
                writer.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        long delta = System.currentTimeMillis() - t;
        logger.log(Level.INFO, "Successful album page generation. (total execution time: " + delta + "ms)");
    }

    public void setMargins(Document document) {
        document.setMargins(PdfUtil.convertFromMillimeters(this.config.getMarginLeft()), PdfUtil.convertFromMillimeters(this.config.getMarginRight()), PdfUtil.convertFromMillimeters(this.config.getMarginTop()), PdfUtil.convertFromMillimeters(this.config.getMarginBottom()));
    }

    public void parseXMLDocument(GenerateBean bean, Document document, PdfWriter writer) throws Exception {
        document.open();
        try {
            org.w3c.dom.Document xmlDoc = this.factory.getDocument(bean.getInputFile());
            if (xmlDoc != null) {
                Element album;
                NodeList pages;
                float boundsWidth = PdfUtil.convertFromMillimeters(this.config.getWidth() - this.config.getMarginLeft() - this.config.getMarginRight());
                float center = boundsWidth / 2.0f + PdfUtil.convertFromMillimeters(this.config.getMarginLeft());
                NodeList albums = xmlDoc.getElementsByTagName("album");
                if (albums != null && albums.getLength() > 0 && (pages = (album = (Element)albums.item(0)).getChildNodes()) != null) {
                    EventBus.publish((Object)new StatusEvent(StatusEvent.StatusType.MaximumProgress, (Object)pages.getLength()));
                    if (bean.isReversePages()) {
                        for (int p = pages.getLength() - 1; p >= 0; --p) {
                            Element elm = (Element)pages.item(p);
                            if (!elm.getTagName().equals("page") && !elm.getTagName().equals("title-page")) continue;
                            this.generatePage(bean, writer, center, elm, p - 1);
                            if (p < 0) continue;
                            document.newPage();
                        }
                    } else {
                        for (int p = 0; p < pages.getLength(); ++p) {
                            Element elm = (Element)pages.item(p);
                            if (!elm.getTagName().equals("page") && !elm.getTagName().equals("title-page")) continue;
                            this.generatePage(bean, writer, center, elm, p + 1);
                            if (p >= pages.getLength() - 1) continue;
                            document.newPage();
                        }
                    }
                }
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        finally {
            document.close();
        }
    }

    protected void generatePage(GenerateBean bean, PdfWriter writer, float center, Element elm, int currentPage) {
        EventBus.publish((Object)new StatusEvent(StatusEvent.StatusType.Progress, (Object)currentPage));
        EventBus.publish((Object)new StatusEvent(StatusEvent.StatusType.Message, (Object)MessageFormat.format(Resources.getString("message.generatingPage"), currentPage)));
        Object p = this.factory.getParser(elm.getTagName()).parse(elm, this.config);
        if (p != null) {
            XMLSerializable page;
            if (bean.isDrawBorder() || this.debug || elm.hasAttribute("border") && Boolean.parseBoolean(elm.getAttribute("border"))) {
                PdfContentByte handler = writer.getDirectContent();
                float width = PdfUtil.convertFromMillimeters(this.config.getWidth() - this.config.getMarginLeft() - this.config.getMarginRight());
                float height = PdfUtil.convertFromMillimeters(this.config.getHeight() - this.config.getMarginTop() - this.config.getMarginBottom());
                handler.rectangle(PdfUtil.convertFromMillimeters(this.config.getMarginLeft()), PdfUtil.convertFromMillimeters(this.config.getMarginBottom()), width, height);
                handler.stroke();
            }
            if (p instanceof Page) {
                page = (Page)p;
                ISetContent[] content = new ISetContent[((Page)page).getContent().size()];
                content = ((Page)page).getContent().toArray(content);
                this.createPage(writer, center, ((Page)page).getTitle(), content);
            } else if (p instanceof TitlePage) {
                page = (TitlePage)p;
                this.createTitlePage(writer, center, ((TitlePage)page).getTitlePageContent());
            }
        }
    }
}

