/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PdfContentByte;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.javad.pdf.OutputBounds;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.util.PdfUtil;
import org.javad.stamp.pdf.AbstractStampContent;
import org.javad.stamp.pdf.IStampContent;
import org.javad.stamp.pdf.StampBox;

public class SetTenant
extends AbstractStampContent
implements IStampContent {
    private final List<StampBox> stamps = new ArrayList<StampBox>();
    private Orientation orientation = Orientation.HORIZONTAL;
    private boolean border = true;

    public SetTenant(PageConfiguration configuration) {
        super(configuration);
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean b) {
        this.border = b;
    }

    public void addStamp(StampBox box) {
        this.stamps.add(box);
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public int getWidth() {
        if (super.getWidth() == 0) {
            int totalWidth = 0;
            block4: for (int i = 0; i < this.stamps.size(); ++i) {
                switch (this.getOrientation()) {
                    case HORIZONTAL: {
                        totalWidth += this.stamps.get(i).getWidth();
                        continue block4;
                    }
                    case VERTICAL: {
                        totalWidth = Math.max(totalWidth, this.stamps.get(i).getWidth());
                    }
                }
            }
            this.setWidth(totalWidth);
        }
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        if (super.getHeight() == 0) {
            int totalHeight = 0;
            block4: for (int i = 0; i < this.stamps.size(); ++i) {
                switch (this.getOrientation()) {
                    case HORIZONTAL: {
                        totalHeight = Math.max(totalHeight, this.stamps.get(i).getHeight());
                        continue block4;
                    }
                    case VERTICAL: {
                        totalHeight += this.stamps.get(i).getHeight();
                    }
                }
            }
            this.setHeight(totalHeight);
        }
        return super.getHeight();
    }

    @Override
    public OutputBounds generate(PdfContentByte contentByte) {
        if (this.isSkipped()) {
            return new OutputBounds(this.getX(), this.getY(), 0.0f, 0.0f);
        }
        float totalWidth = PdfUtil.convertFromMillimeters(this.getWidth() + this.getPadding());
        float totalHeight = PdfUtil.convertFromMillimeters(this.getHeight() + this.getVerticalPadding());
        OutputBounds rect = new OutputBounds(this.getX(), this.getY(), totalWidth, totalHeight);
        float cur_x = this.getX();
        float cur_y = this.getY();
        for (int i = this.stamps.size() - 1; i >= 0; --i) {
            StampBox s = this.stamps.get(i);
            s.setPadding(this.getCalculatedPadding(s, this.getOrientation(), false));
            s.setVerticalPadding(this.getCalculatedPadding(s, this.getOrientation(), true));
            s.setX(cur_x);
            s.setY(cur_y);
            s.setTextPadding(this.getOrientation() == Orientation.VERTICAL ? 1.0f + (float)this.getVerticalPadding() / 2.0f : 0.0f);
            OutputBounds bounds = s.generate(contentByte);
            cur_x += this.getOrientation() == Orientation.HORIZONTAL ? bounds.getWidth() : 0.0f;
            cur_y += this.getOrientation() == Orientation.VERTICAL ? bounds.getHeight() : 0.0f;
            if (i <= 0 || !this.isBorder()) continue;
            this.drawSeparator(contentByte, cur_x, cur_y, totalWidth, totalHeight);
        }
        if (this.isBorder()) {
            this.drawBorder(contentByte, rect);
        }
        return rect;
    }

    protected void drawSeparator(PdfContentByte content, float x, float y, float width, float height) {
        float sx = this.getOrientation() == Orientation.HORIZONTAL ? x : x + PdfUtil.convertFromMillimeters(this.getPadding() + 2);
        float dx = this.getOrientation() == Orientation.HORIZONTAL ? x : x + width - PdfUtil.convertFromMillimeters(this.getPadding() + 2);
        float sy = this.getOrientation() == Orientation.HORIZONTAL ? y + PdfUtil.convertFromMillimeters(this.getVerticalPadding() + 2) : y;
        float dy = this.getOrientation() == Orientation.HORIZONTAL ? y + height - PdfUtil.convertFromMillimeters(this.getVerticalPadding() + 2) : y;
        content.setLineWidth(0.5f);
        content.setColorStroke(BaseColor.GRAY);
        content.moveTo(sx, sy);
        content.setLineDash(5.0f, 2.0f, 0.0f);
        content.lineTo(dx, dy);
        content.stroke();
        content.setLineDash(1.0f, 0.0f, 0.0f);
    }

    protected int getCalculatedPadding(StampBox box, Orientation orientation, boolean vertical) {
        int padding = 0;
        switch (orientation) {
            case HORIZONTAL: {
                if (vertical) {
                    padding = this.getVerticalPadding();
                    break;
                }
                padding = box.getSetTenantPosition() == StampBox.SetTenantPosition.first || box.getSetTenantPosition() == StampBox.SetTenantPosition.last ? this.getPadding() / 2 : 0;
                break;
            }
            case VERTICAL: {
                padding = vertical ? (box.getSetTenantPosition() == StampBox.SetTenantPosition.first || box.getSetTenantPosition() == StampBox.SetTenantPosition.last ? this.getVerticalPadding() / 2 : 0) : this.getPadding();
            }
        }
        return padding;
    }

    void drawBorder(PdfContentByte content, OutputBounds rect) {
        content.setColorStroke(BaseColor.BLACK);
        content.setLineWidth(0.8f);
        content.rectangle(rect.x, rect.y, rect.width, rect.height);
        content.stroke();
    }

    @Override
    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

