/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.bushe.swing.event.EventBus;
import org.javad.components.ISettingsPanel;
import org.javad.components.IconLabel;
import org.javad.events.StatusEvent;
import org.javad.pdf.fonts.ui.FontMappingPanel;
import org.javad.pdf.fonts.ui.FontSettingPanel;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.model.PageConfigurations;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.ui.IPageConfigurationSettingsPanel;
import org.javad.stamp.pdf.ui.PageLayoutSettingsPanel;
import pub.domain.GradientPanel;

public class SettingsDialog
extends JDialog {
    private JPanel buttonPanel;
    private JTabbedPane tabbedPane;
    private JButton buttonOk;
    private JButton buttonCancel;
    private GradientPanel mainPanel;
    private PageLayoutSettingsPanel pageLayoutSettingsPanel;
    private FontMappingPanel fontMappingPanel;
    private FontSettingPanel fontSettingPanel;
    private Logger logger = Logger.getLogger(SettingsDialog.class.getName());

    public SettingsDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource(Resources.getIconName("icon.settings"))));
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Icon failed to load.", e);
        }
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.getContentPane().add((Component)this.getMainPanel());
        this.setSize(700, 500);
        this.setTitle(Resources.getString("title.settings"));
        this.setName("settingsDialog");
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            PageConfiguration configuration = PageConfigurations.getInstance().getActiveConfiguration();
            for (int i = 0; i < this.getTabbedPane().getComponentCount(); ++i) {
                Component c = this.getTabbedPane().getComponent(i);
                if (!(c instanceof ISettingsPanel)) continue;
                ISettingsPanel panel = (ISettingsPanel)c;
                if (panel instanceof IPageConfigurationSettingsPanel) {
                    ((IPageConfigurationSettingsPanel)panel).setConfiguration(configuration);
                }
                panel.loadSettings();
            }
        }
        super.setVisible(visible);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setMinimumSize(new Dimension(100, 40));
            this.buttonPanel.setBorder(null);
            this.buttonPanel.setPreferredSize(new Dimension(100, 40));
            this.buttonPanel.setOpaque(false);
            this.buttonPanel.setLayout(new FlowLayout(2, 5, 5));
            this.buttonPanel.add(this.getButtonOk());
            this.buttonPanel.add(this.getButtonCancel());
        }
        return this.buttonPanel;
    }

    protected JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(2);
            this.tabbedPane.setBorder(new EtchedBorder(1, null, null));
            this.tabbedPane.addTab("", null, this.getPageLayoutSettingsPanel(), null);
            this.tabbedPane.addTab("", null, this.getFontSettingPanel(), null);
            this.tabbedPane.addTab("", null, this.getFontMappingPanel(), null);
            IconLabel pageSettingsLabel = new IconLabel(Resources.getString("settings.tab.margins"), Resources.getIcon("icon.margins.medium"));
            pageSettingsLabel.setPreferredSize(new Dimension(100, 65));
            pageSettingsLabel.setName("settingsDialog-pageSettings");
            IconLabel fontMappingLabel = new IconLabel(Resources.getString("settings.tab.fontMapping"), Resources.getIcon("icon.fontmapping.medium"));
            fontMappingLabel.setPreferredSize(new Dimension(100, 65));
            fontMappingLabel.setName("settingsDialog-fontMappingLabel");
            IconLabel fontLabel = new IconLabel(Resources.getString("settings.tab.fonts"), Resources.getIcon("icon.systemFont.medium"));
            fontLabel.setPreferredSize(new Dimension(100, 65));
            fontLabel.setName("settingsDialog-fontSettingLabel");
            this.tabbedPane.setTabComponentAt(0, (Component)pageSettingsLabel);
            this.tabbedPane.setTabComponentAt(1, (Component)fontLabel);
            this.tabbedPane.setTabComponentAt(2, (Component)fontMappingLabel);
        }
        return this.tabbedPane;
    }

    protected FontSettingPanel getFontSettingPanel() {
        if (this.fontSettingPanel == null) {
            this.fontSettingPanel = new FontSettingPanel();
            this.fontSettingPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Resources.getString("settings.tab.fonts.title"), 4, 2, null, new Color(0, 0, 0)));
            this.fontSettingPanel.setOpaque(false);
        }
        return this.fontSettingPanel;
    }

    protected FontMappingPanel getFontMappingPanel() {
        if (this.fontMappingPanel == null) {
            this.fontMappingPanel = new FontMappingPanel();
            this.fontMappingPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Resources.getString("settings.tab.fontMapping.title"), 4, 2, null, new Color(0, 0, 0)));
            this.fontMappingPanel.setOpaque(false);
        }
        return this.fontMappingPanel;
    }

    protected PageLayoutSettingsPanel getPageLayoutSettingsPanel() {
        if (this.pageLayoutSettingsPanel == null) {
            this.pageLayoutSettingsPanel = new PageLayoutSettingsPanel();
            this.pageLayoutSettingsPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Resources.getString("settings.tab.margins.pageLayout"), 4, 2, null, new Color(0, 0, 0)));
            this.pageLayoutSettingsPanel.setOpaque(false);
        }
        return this.pageLayoutSettingsPanel;
    }

    protected JButton getButtonOk() {
        if (this.buttonOk == null) {
            this.buttonOk = new JButton("");
            this.buttonOk.setPreferredSize(new Dimension(85, 27));
            this.buttonOk.setName("settingsDialog-ok");
            this.buttonOk.setAction(new SaveAction());
            this.buttonOk.setMinimumSize(new Dimension(85, 27));
        }
        return this.buttonOk;
    }

    protected JButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new JButton("");
            this.buttonCancel.setPreferredSize(new Dimension(85, 27));
            this.buttonCancel.setAction(new CancelAction());
            this.buttonCancel.setMinimumSize(new Dimension(85, 27));
            this.buttonCancel.setName("settingsDialog-cancel");
        }
        return this.buttonCancel;
    }

    protected GradientPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new GradientPanel();
            this.mainPanel.setDirection(0);
            this.mainPanel.setBackground(new Color(211, 211, 211));
            this.mainPanel.setForeground(new Color(248, 248, 255));
            this.mainPanel.setDirection(1);
            this.mainPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.mainPanel.add((Component)this.getButtonPanel(), (Object)"South");
            this.mainPanel.add((Component)this.getTabbedPane(), (Object)"Center");
        }
        return this.mainPanel;
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            this.putValue("Name", Resources.getString("button.ok"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventBus.publish((Object)new StatusEvent(StatusEvent.StatusType.ShowBusy, (Object)Resources.getString("message.savingSetting")));
            for (Component c : SettingsDialog.this.getTabbedPane().getComponents()) {
                if (!(c instanceof ISettingsPanel)) continue;
                ISettingsPanel panel = (ISettingsPanel)c;
                panel.saveSettings();
            }
            EventBus.publish((Object)new StatusEvent(StatusEvent.StatusType.Finished, (Object)""));
            SettingsDialog.this.setVisible(false);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", Resources.getString("button.cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsDialog.this.setVisible(false);
        }
    }
}

