/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.pdf.ui.tasks;

import java.io.File;
import java.util.Map;
import javax.swing.SwingWorker;
import org.bushe.swing.event.EventBus;
import org.javad.events.StatusEvent;
import org.javad.stamp.htmlparser.msword.AlbumParser;
import org.javad.stamp.htmlparser.msword.styles.PageStyle;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.events.PdfAppEvent;

public class GenerateXmlTask
extends SwingWorker<Void, Void> {
    private final Map<String, String> bean;
    private boolean errorRaised = false;

    public GenerateXmlTask(Map<String, String> bean) {
        this.bean = bean;
    }

    @Override
    protected Void doInBackground() throws Exception {
        AlbumParser parser = new AlbumParser();
        try {
            File input = new File(this.bean.get("input"));
            String out = this.bean.get("output") + File.separator + input.getName();
            out = out.substring(0, out.lastIndexOf(".html")) + ".xml";
            PageStyle style = PageStyle.StyleType.valueOf(this.bean.get("pageType")).getPageStyle();
            parser.parse(style, input.getAbsolutePath(), out);
        }
        catch (Throwable t) {
            this.errorRaised = true;
            EventBus.publish((Object)new PdfAppEvent(PdfAppEvent.EventType.Generate_Error, t));
        }
        return null;
    }

    @Override
    protected void done() {
        EventBus.publish((Object)new StatusEvent(StatusEvent.StatusType.Finished, (Object)Resources.getString("message.finished")));
        if (!this.errorRaised) {
            EventBus.publish((Object)new PdfAppEvent(PdfAppEvent.EventType.Generated, null));
        }
    }
}

