/*
 * Decompiled with CFR 0.152.
 */
package org.javad.stamp.xml;

import org.javad.pdf.SpacingMode;
import org.javad.pdf.model.PageConfiguration;
import org.javad.stamp.pdf.ColumnSet;
import org.javad.stamp.pdf.StampSet;
import org.javad.stamp.xml.AbstractXMLParser;
import org.javad.stamp.xml.XMLDefinitions;
import org.javad.xml.XML;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ColumnSetParser
extends AbstractXMLParser<ColumnSet>
implements XMLDefinitions {
    @Override
    public ColumnSet parse(Element element, PageConfiguration configuration) {
        NodeList sets;
        ColumnSet cols = new ColumnSet(configuration);
        if (element.hasAttribute("skip")) {
            cols.parseSkipTerms(element.getAttribute("skip"));
        }
        if (element.hasAttribute("spacing")) {
            cols.setSpacingMode(SpacingMode.valueOf(element.getAttribute("spacing").toLowerCase()));
        }
        if (element.hasAttribute("issue")) {
            cols.setIssue(XML.normalize(element.getAttribute("issue")));
        }
        if ((sets = element.getElementsByTagName("set")) != null) {
            for (int i = 0; i < sets.getLength(); ++i) {
                Element s = (Element)sets.item(i);
                StampSet sc = (StampSet)ColumnSetParser.getFactory().getParser("set").parse(s, configuration);
                if (sc == null) continue;
                cols.addStampSet(sc);
            }
        }
        return cols;
    }
}

