/*
 * Decompiled with CFR 0.152.
 */
package colorzoo;

import colorzoo.ColorPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

class SaturationBrightnessPanel
extends JPanel {
    private float hue = 0.0f;
    public ColorPanel col;
    private Point2D last_point = new Point2D.Double(0.0, 0.0);
    public int mode = 0;

    public SaturationBrightnessPanel(int n) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SaturationBrightnessPanel.this.last_point = mouseEvent.getPoint();
                SaturationBrightnessPanel.this.col.setColor(SaturationBrightnessPanel.this.toColor(mouseEvent.getPoint()));
                SaturationBrightnessPanel.this.repaint();
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                SaturationBrightnessPanel.this.last_point = mouseEvent.getPoint();
                SaturationBrightnessPanel.this.col.setColor(SaturationBrightnessPanel.this.toColor(mouseEvent.getPoint()));
                SaturationBrightnessPanel.this.repaint();
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this.mode = n;
    }

    public void paintComponent(Graphics graphics) {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                graphics.setColor(this.toColor(i, j));
                graphics.fillRect(i, j, 1, 1);
            }
        }
        graphics.setColor(Color.black);
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(0, this.getHeight());
        polygon.addPoint(this.getWidth() / 2, 0);
        polygon = new Polygon();
        polygon.addPoint(this.getWidth(), 0);
        polygon.addPoint(this.getWidth(), this.getHeight());
        polygon.addPoint(this.getWidth() / 2, 0);
        graphics.setColor(Color.BLUE);
        graphics.drawString("mode = " + this.mode, 50, 50);
        graphics.drawOval((int)this.last_point.getX() - 5, (int)this.last_point.getY() - 5, 10, 10);
    }

    private Color toColor(Point2D point2D) {
        return this.toColor((int)point2D.getX(), (int)point2D.getY());
    }

    private Color toColor(int n, int n2) {
        float f = (float)n2 / (float)this.getHeight();
        float f2 = (float)n / (float)this.getWidth();
        float f3 = this.getWidth();
        float f4 = this.getHeight();
        float f5 = (float)n2 / f4;
        if (this.mode == 2) {
            f2 -= 0.5f * (1.0f - (float)n2 / f4);
            f2 = f2 * f4 / (float)n2;
        }
        if (this.mode == 3 && (f2 += 0.5f * (1.0f - f5)) < 1.0f - f) {
            f2 = -1.0f;
        }
        if (this.mode == 4) {
            if (f2 + f5 < 1.0f - f) {
                f2 = -1.0f;
            }
            if (f2 - f5 + 1.0f < f) {
                f2 = -1.0f;
            }
        }
        if (this.mode == 5) {
            f = (float)n2 / (float)this.getHeight();
            f -= 0.5f * (1.0f - (float)n / f3);
            f = f * f3 / (float)n;
        }
        if (f < 0.0f || f > 1.0f) {
            f2 = 1.0f;
            f = 0.0f;
        }
        if (f2 < 0.0f || f2 > 1.0f) {
            f2 = 1.0f;
            f = 0.0f;
        }
        int n3 = Color.HSBtoRGB(this.hue, f, f2);
        return new Color(n3);
    }

    public void setHue(float f) {
        this.hue = f;
        this.col.setColor(this.toColor(this.last_point));
        this.repaint();
    }

    public static void p(String string) {
        System.out.println(string);
    }
}

