/*
 * Decompiled with CFR 0.152.
 */
package colorzoo.schemeeditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class ColorSchemePanel
extends JPanel {
    private Color selectedColor = Color.blue;
    private Color matchA = null;
    private Color matchB = null;
    private MatchType type = MatchType.Single;

    public ColorSchemePanel() {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Color color = ColorSchemePanel.this.getColor(mouseEvent.getPoint());
                ColorSchemePanel.this.setSelectedColor(color);
                ColorSchemePanel.this.generateMatchColors(color);
                ColorSchemePanel.this.firePropertyChange("selectedColor", ColorSchemePanel.this.getSelectedColor(), color.getRGB());
                ColorSchemePanel.this.repaint();
            }
        };
        this.addMouseListener(mouseInputAdapter);
    }

    private void generateMatchColors(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if (this.getType() == MatchType.Single) {
            this.setMatchA(null);
            this.setMatchB(null);
        }
        if (this.getType() == MatchType.Complimentary) {
            this.setMatchA(new Color(Color.HSBtoRGB(fArray[0] + 0.5f, fArray[1], fArray[2])));
            this.setMatchB(null);
        }
        if (this.getType() == MatchType.SplitComplimentary) {
            this.setMatchA(new Color(Color.HSBtoRGB(fArray[0] + 0.5f + 0.083333336f, fArray[1], fArray[2])));
            this.setMatchB(new Color(Color.HSBtoRGB(fArray[0] + 0.5f - 0.083333336f, fArray[1], fArray[2])));
        }
        if (this.getType() == MatchType.Triad) {
            this.setMatchA(new Color(Color.HSBtoRGB(fArray[0] - 0.33333334f, fArray[1], fArray[2])));
            this.setMatchB(new Color(Color.HSBtoRGB(fArray[0] + 0.33333334f, fArray[1], fArray[2])));
        }
        if (this.getType() == MatchType.Analog) {
            this.setMatchA(new Color(Color.HSBtoRGB(fArray[0] - 0.083333336f, fArray[1], fArray[2])));
            this.setMatchB(new Color(Color.HSBtoRGB(fArray[0] + 0.083333336f, fArray[1], fArray[2])));
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public Color getColor(Point2D point2D) {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.paintComponent(bufferedImage.getGraphics());
        return new Color(bufferedImage.getRGB((int)point2D.getX(), (int)point2D.getY()));
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point2D.Double double_ = new Point2D.Double(this.getWidth() / 2, this.getHeight() / 2);
        graphics2D.translate(((Point2D)double_).getX(), ((Point2D)double_).getY());
        int n2 = 12;
        int n3 = 3;
        for (n = 0; n < n2; ++n) {
            float f = 1.0f / (float)n2 * (float)n;
            int n4 = 0;
            for (int i = 0; i <= n3; ++i) {
                float f2 = 1.0f / (float)n3 * (float)i;
                int n5 = 5 * i * i / 2 + 4;
                n4 = n4 + n5 - 1;
                Color color = new Color(Color.HSBtoRGB(f, f2, 1.0f));
                Stroke stroke = graphics2D.getStroke();
                if (this.distance(color, this.getSelectedColor()) < 5) {
                    this.drawPrimarySelected(n5, n4, graphics2D);
                } else if (this.distance(color, this.getMatchA()) < 5 || this.distance(color, this.getMatchB()) < 5) {
                    this.drawSecondarySelected(n5, n4, graphics2D);
                }
                graphics2D.setStroke(stroke);
                graphics2D.setColor(color);
                graphics2D.fillOval(5 + n4, -n5 / 2, n5, n5);
                graphics2D.setColor(Color.black);
                graphics2D.drawOval(5 + n4, -n5 / 2, n5, n5);
            }
            graphics2D.rotate(Math.PI * 2 / (double)n2);
        }
        graphics2D.setColor(new Color(Color.HSBtoRGB(1.0f, 0.0f, 1.0f)));
        n = 10;
        graphics2D.fillOval(-n / 2, -n / 2, n, n);
        graphics2D.setColor(Color.black);
        graphics2D.drawOval(-n / 2, -n / 2, n, n);
    }

    private void drawPrimarySelected(int n, int n2, Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke(5.0f));
        graphics2D.setColor(Color.black);
        graphics2D.drawOval(5 + n2, -n / 2, n, n);
    }

    public void setMatchType(MatchType matchType) {
        this.setType(matchType);
        this.generateMatchColors(this.getSelectedColor());
        this.repaint();
    }

    private void drawSecondarySelected(int n, int n2, Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke(7.0f));
        graphics2D.setColor(Color.black);
        graphics2D.drawOval(5 + n2, -n / 2, n, n);
        graphics2D.setStroke(new BasicStroke(5.0f));
        graphics2D.setColor(Color.white);
        graphics2D.drawOval(5 + n2, -n / 2, n, n);
    }

    private int distance(Color color, Color color2) {
        if (color == null || color2 == null) {
            return 255;
        }
        int n = Math.abs(color.getRed() - color2.getRed());
        int n2 = Math.abs(color.getGreen() - color2.getGreen());
        int n3 = Math.abs(color.getBlue() - color2.getBlue());
        return n + n2 + n3;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
    }

    public Color getMatchA() {
        return this.matchA;
    }

    public void setMatchA(Color color) {
        this.matchA = color;
    }

    public Color getMatchB() {
        return this.matchB;
    }

    public void setMatchB(Color color) {
        this.matchB = color;
    }

    public MatchType getType() {
        return this.type;
    }

    public void setType(MatchType matchType) {
        this.type = matchType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchType {
        Single,
        Analog,
        Complimentary,
        SplitComplimentary,
        Triad;

    }
}

