/*
 * Decompiled with CFR 0.152.
 */
package org.javad.components;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.javad.components.ComponentResources;
import org.javad.components.LinkLabel;
import org.javad.components.UIHelper;
import org.javad.components.model.AboutDialogBean;
import pub.domain.GradientPanel;

public class AboutDialog
extends JDialog {
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private JButton btnOk;
    private JLabel labelIcon;
    private JPanel panel;
    private JScrollPane scrollPane;
    private JTextPane licenseText;
    private JLabel labelAppInfo;
    private GradientPanel contentPanel;
    private LinkLabel labelLink;
    private static Logger logger = Logger.getLogger(AboutDialog.class.getName());
    private static String LICENSE_INFO = null;
    private AboutDialogBean modelBean;

    public AboutDialog(AboutDialogBean bean) {
        AnnotationProcessor.process((Object)this);
        this.setModelBean(bean);
        this.setTitle(bean.getTitle());
        this.initialize();
    }

    public void setModelBean(AboutDialogBean modelBean) {
        this.modelBean = modelBean;
    }

    public AboutDialogBean getModelBean() {
        return this.modelBean;
    }

    private void initialize() {
        this.setResizable(false);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setModal(true);
        this.setSize(640, 400);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.getContentPane().add(this.getContentPanel());
        this.getVersionAndLicenseInformation();
    }

    @EventSubscriber(eventClass=AboutEvent.class)
    public void onActionEvent(AboutEvent event) {
        if (event.getType() == EventType.LICENSE_INFO_PROCESSED) {
            List info = (List)event.getData();
            LICENSE_INFO = (String)info.get(0);
            this.setLicenseInfo();
            String version = info.size() > 1 && !((String)info.get(1)).isEmpty() ? (String)info.get(1) : ComponentResources.getString("message.unknown");
            this.getLabelAppInfo().setText(this.getBuildVersion(version));
        }
    }

    private void setLicenseInfo() {
        try {
            this.getLicenseText().setText("");
            this.getLicenseText().getStyledDocument().insertString(0, LICENSE_INFO, null);
            this.getLicenseText().setCaretPosition(0);
        }
        catch (BadLocationException e) {
            logger.log(Level.SEVERE, "Issue specifying the license text in the document.", e);
        }
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setOpaque(false);
            GroupLayout gl_mainPanel = new GroupLayout(this.mainPanel);
            gl_mainPanel.setHorizontalGroup(gl_mainPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_mainPanel.createSequentialGroup().addContainerGap().addGroup(gl_mainPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getScrollPane(), -1, 464, Short.MAX_VALUE).addGroup(gl_mainPanel.createSequentialGroup().addComponent(this.getLabelIcon()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getPanel(), -1, 364, Short.MAX_VALUE))).addContainerGap()));
            gl_mainPanel.setVerticalGroup(gl_mainPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_mainPanel.createSequentialGroup().addContainerGap().addGroup(gl_mainPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLabelIcon()).addComponent(this.getPanel(), -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getScrollPane(), -1, 179, Short.MAX_VALUE).addContainerGap()));
            this.mainPanel.setLayout(gl_mainPanel);
        }
        return this.mainPanel;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setPreferredSize(new Dimension(100, 40));
            this.buttonPanel.setOpaque(false);
            FlowLayout flowLayout = (FlowLayout)this.buttonPanel.getLayout();
            flowLayout.setAlignment(2);
            this.buttonPanel.add(this.getBtnOk());
        }
        return this.buttonPanel;
    }

    protected JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton(ComponentResources.getString("button.ok"));
            this.btnOk.setPreferredSize(new Dimension(75, 23));
            this.btnOk.setName("btn-ok");
            this.btnOk.setAction(new CloseDialogAction());
        }
        return this.btnOk;
    }

    protected JLabel getLabelIcon() {
        if (this.labelIcon == null) {
            this.labelIcon = new JLabel("");
            this.labelIcon.setMinimumSize(new Dimension(96, 96));
            this.labelIcon.setIcon(this.getModelBean().getApplicationIcon());
            this.labelIcon.setPreferredSize(new Dimension(96, 96));
        }
        return this.labelIcon;
    }

    protected JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setOpaque(false);
            GroupLayout gl_panel = new GroupLayout(this.panel);
            gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLabelLink(), -1, 364, Short.MAX_VALUE).addComponent(this.getLabelAppInfo(), -1, 364, Short.MAX_VALUE));
            gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addComponent(this.getLabelAppInfo(), -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getLabelLink()).addContainerGap(-1, Short.MAX_VALUE)));
            this.panel.setLayout(gl_panel);
        }
        return this.panel;
    }

    protected JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getLicenseText());
        }
        return this.scrollPane;
    }

    protected JTextPane getLicenseText() {
        if (this.licenseText == null) {
            this.licenseText = new JTextPane();
            this.licenseText.setFont(new Font("Courier New", 0, 11));
            this.licenseText.setName("text-license");
            this.licenseText.setEditable(false);
        }
        return this.licenseText;
    }

    protected JLabel getLabelAppInfo() {
        if (this.labelAppInfo == null) {
            this.labelAppInfo = new JLabel();
            this.labelAppInfo.setText(this.getBuildVersion(ComponentResources.getString("message.unknown")));
        }
        return this.labelAppInfo;
    }

    private String getBuildVersion(String version) {
        String s = MessageFormat.format(this.getModelBean().getApplicationInfo(), version);
        return UIHelper.convertToMultiline(s);
    }

    protected void getVersionAndLicenseInformation() {
        if (LICENSE_INFO == null) {
            this.getLicenseText().setText(ComponentResources.getString("message.readingLicense"));
            new LicenseAndVersionLoader().execute();
        } else {
            this.setLicenseInfo();
        }
    }

    protected JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new GradientPanel();
            this.contentPanel.setBackground(UIHelper.Dark_Grey);
            this.contentPanel.setForeground(UIHelper.Medium_Grey);
            this.contentPanel.setDirection(1);
            GroupLayout gl_contentPanel = new GroupLayout(this.contentPanel);
            gl_contentPanel.setHorizontalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.getButtonPanel(), -1, 640, Short.MAX_VALUE).addComponent(this.getMainPanel(), -1, 624, Short.MAX_VALUE));
            gl_contentPanel.setVerticalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_contentPanel.createSequentialGroup().addComponent(this.getMainPanel(), -1, 353, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getButtonPanel(), -2, 41, -2)));
            this.contentPanel.setLayout(gl_contentPanel);
        }
        return this.contentPanel;
    }

    protected LinkLabel getLabelLink() {
        if (this.labelLink == null) {
            this.labelLink = new LinkLabel();
            this.labelLink.setName("aboutDialog-softwareLink");
            this.labelLink.setText(this.getModelBean().getApplicationLink());
        }
        return this.labelLink;
    }

    public static enum EventType {
        LICENSE_INFO_PROCESSED;

    }

    public class AboutEvent {
        private EventType type;
        private Object data;
        private Object source;

        public AboutEvent(EventType type) {
            this.type = type;
        }

        public AboutEvent(EventType type, Object data) {
            this(type);
            this.data = data;
        }

        public AboutEvent(EventType type, Object data, Object source) {
            this(type, data);
            this.setSource(source);
        }

        public void setSource(Object source) {
            this.source = source;
        }

        public EventType getType() {
            return this.type;
        }

        public <X> X getSource() {
            return (X)this.source;
        }

        public <X> X getData() {
            return (X)this.data;
        }
    }

    private class CloseDialogAction
    extends AbstractAction {
        public CloseDialogAction() {
            this.putValue("Name", ComponentResources.getString("button.ok"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog.this.dispose();
        }
    }

    public class LicenseAndVersionLoader
    extends SwingWorker<Void, String> {
        private StringBuilder buf = new StringBuilder(4096);
        private StringBuilder build = new StringBuilder(512);

        @Override
        protected Void doInBackground() throws Exception {
            this.readFile(this.buf, "/VERSION.txt");
            this.readFile(this.buf, "/NOTICE.txt");
            this.readFile(this.build, "/buildInfo.txt");
            return null;
        }

        private void readFile(StringBuilder buf, String resource) {
            try {
                String str;
                BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resource)));
                while ((str = in.readLine()) != null) {
                    if (buf.length() > 0) {
                        buf.append('\n');
                    }
                    buf.append(str);
                }
                in.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unexpected error reading " + resource, e);
            }
        }

        @Override
        protected void done() {
            ArrayList<String> info = new ArrayList<String>();
            info.add(this.buf.toString());
            info.add(this.build.toString());
            AboutEvent event = new AboutEvent(EventType.LICENSE_INFO_PROCESSED, info);
            EventBus.publish((Object)event);
        }
    }
}

