/*
 * Decompiled with CFR 0.152.
 */
package org.javad.components;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.javad.components.ComponentResources;

public class MemoryStatus
extends JPanel {
    private JProgressBar memoryBar;
    private Timer timer;
    final NumberFormat formatter = NumberFormat.getPercentInstance();
    private String msg = null;

    public MemoryStatus() {
        this.setPreferredSize(new Dimension(75, 18));
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.add(this.getMemoryBar());
    }

    protected JProgressBar getMemoryBar() {
        if (this.memoryBar == null) {
            this.memoryBar = new JProgressBar();
            this.memoryBar.setStringPainted(true);
            this.memoryBar.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Runtime.getRuntime().gc();
                }
            });
            this.msg = ComponentResources.getString("message.memory.tooltip");
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    long total = Runtime.getRuntime().totalMemory() / 0x100000L;
                    long free = Runtime.getRuntime().freeMemory() / 0x100000L;
                    long max = Runtime.getRuntime().maxMemory() / 0x100000L;
                    float memory = 100.0f * (float)(total - free) / (float)max;
                    MemoryStatus.this.getMemoryBar().setValue(Float.valueOf(memory).intValue());
                    MemoryStatus.this.getMemoryBar().setToolTipText(MessageFormat.format(MemoryStatus.this.msg, total - free, total, max));
                    MemoryStatus.this.getMemoryBar().setString(MemoryStatus.this.formatter.format((double)memory / 100.0));
                }
            };
            this.timer = new Timer(1000, taskPerformer);
            this.timer.setRepeats(true);
            this.timer.start();
        }
        return this.memoryBar;
    }
}

