/*
 * Decompiled with CFR 0.152.
 */
package org.javad.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.BevelBorder;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.javad.components.ComponentResources;
import org.javad.components.MemoryStatus;
import org.javad.components.UIHelper;
import org.javad.events.PositionEvent;
import org.javad.events.StatusEvent;
import org.javad.events.ZoomEvent;
import pub.domain.GradientPanel;

public class StatusPanel
extends GradientPanel {
    private JProgressBar progressBar;
    private JLabel lblStatusLabel;
    private JLabel lblZoomLabel;
    private JLabel lblPositionLabel;
    private MemoryStatus memoryStatus;
    private JPanel componentPanel;
    private JPanel progressPanel;

    public StatusPanel() {
        AnnotationProcessor.process((Object)this);
        this.setForeground(UIHelper.Dark_Grey);
        this.setBackground(UIHelper.Medium_Grey);
        this.setPreferredSize(new Dimension(703, 25));
        this.setOpaque(false);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getComponentPanel(), "East");
        this.add((Component)this.getProgressPanel(), "West");
    }

    public void showZoomLabel(boolean showZoom) {
        this.getLblZoomLabel().setVisible(showZoom);
    }

    public void showPositionLabel(boolean showPosition) {
        this.getLblPositionLabel().setVisible(showPosition);
    }

    @EventSubscriber(eventClass=PositionEvent.class)
    public void onPositionChange(PositionEvent event) {
        this.getLblPositionLabel().setText(event.getPoint().x + "," + event.getPoint().y);
    }

    @EventSubscriber(eventClass=ZoomEvent.class)
    public void onZoom(ZoomEvent event) {
        NumberFormat formatter = NumberFormat.getPercentInstance();
        this.getLblZoomLabel().setText(MessageFormat.format(ComponentResources.getString("label.zoom.ratio"), formatter.format(event.getRatio())));
    }

    @EventSubscriber(eventClass=StatusEvent.class)
    public void onStatusUpdate(StatusEvent event) {
        if (event.getType() == StatusEvent.StatusType.ShowBusy) {
            this.getProgressBar().setIndeterminate(true);
            this.getProgressBar().setVisible(true);
        }
        switch (event.getType()) {
            case ShowBusy: 
            case Message: {
                String text = (String)event.getData();
                if (text != null) {
                    this.getLblStatusLabel().setText(text);
                    this.getLblStatusLabel().setVisible(true);
                    break;
                }
                this.getLblStatusLabel().setVisible(false);
                break;
            }
            case Progress: {
                int value = Integer.parseInt(event.getData().toString());
                if (value > 0) {
                    this.getProgressBar().setIndeterminate(false);
                    this.getProgressBar().setValue(value);
                    this.getProgressBar().setVisible(true);
                    break;
                }
                this.getProgressBar().setVisible(false);
                break;
            }
            case Finished: {
                this.getProgressBar().setVisible(false);
                String text = (String)event.getData();
                if (text != null) {
                    this.getLblStatusLabel().setText(text);
                    this.getLblStatusLabel().setVisible(true);
                    break;
                }
                this.getLblStatusLabel().setVisible(false);
                break;
            }
            case MaximumProgress: {
                Integer total = (Integer)event.getData();
                this.getProgressBar().setMaximum(total);
            }
        }
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setPreferredSize(new Dimension(120, 17));
            this.progressBar.setName("status-progressBar");
            this.progressBar.setVisible(false);
        }
        return this.progressBar;
    }

    protected JLabel getLblStatusLabel() {
        if (this.lblStatusLabel == null) {
            this.lblStatusLabel = new JLabel("");
            this.lblStatusLabel.setPreferredSize(new Dimension(250, 17));
            this.lblStatusLabel.setForeground(new Color(255, 255, 255));
        }
        return this.lblStatusLabel;
    }

    protected JLabel getLblZoomLabel() {
        if (this.lblZoomLabel == null) {
            this.lblZoomLabel = new JLabel(ComponentResources.getString("label.zoom.full"));
            this.lblZoomLabel.setHorizontalAlignment(0);
            this.lblZoomLabel.setPreferredSize(new Dimension(100, 15));
            this.lblZoomLabel.setBorder(new BevelBorder(1, null, null, null, null));
        }
        return this.lblZoomLabel;
    }

    protected JLabel getLblPositionLabel() {
        if (this.lblPositionLabel == null) {
            this.lblPositionLabel = new JLabel(ComponentResources.getString("label.coord.init"));
            this.lblPositionLabel.setHorizontalAlignment(0);
            this.lblPositionLabel.setPreferredSize(new Dimension(100, 15));
            this.lblPositionLabel.setBorder(new BevelBorder(1, null, null, null, null));
        }
        return this.lblPositionLabel;
    }

    protected MemoryStatus getMemoryStatus() {
        if (this.memoryStatus == null) {
            this.memoryStatus = new MemoryStatus();
            this.memoryStatus.setPreferredSize(new Dimension(75, 17));
            this.memoryStatus.setBorder(null);
        }
        return this.memoryStatus;
    }

    protected JPanel getComponentPanel() {
        if (this.componentPanel == null) {
            this.componentPanel = new JPanel();
            this.componentPanel.setOpaque(false);
            FlowLayout fl_componentPanel = (FlowLayout)this.componentPanel.getLayout();
            fl_componentPanel.setAlignment(2);
            this.componentPanel.add(this.getProgressBar());
            this.componentPanel.add(this.getMemoryStatus());
            this.componentPanel.add(this.getLblPositionLabel());
            this.componentPanel.add(this.getLblZoomLabel());
        }
        return this.componentPanel;
    }

    protected JPanel getProgressPanel() {
        if (this.progressPanel == null) {
            this.progressPanel = new JPanel();
            this.progressPanel.setOpaque(false);
            this.progressPanel.add(this.getLblStatusLabel());
        }
        return this.progressPanel;
    }
}

