/*
 * Decompiled with CFR 0.152.
 */
package org.javad.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class UIHelper {
    public static Color Dark_Grey = new Color(150, 150, 150);
    public static Color Medium_Grey = new Color(240, 240, 248);
    public static Color Select_Grey = new Color(175, 175, 185);
    public static final int MEGA_BYTES = 0x100000;
    private static Boolean INTERNAL = null;
    private static Boolean BROWSING_SUPPORTED = null;
    private static Properties SETTINGS = null;
    private static long INITIAL_MEMORY = 50L;
    private static Logger logger = Logger.getLogger(UIHelper.class.getName());

    public static void center(Component parent, JDialog dialog) {
        Rectangle r = parent.getBounds();
        if (r.width < dialog.getSize().width || r.height < dialog.getSize().height) {
            dialog.setLocation(5, 5);
        } else {
            int x = r.x + (r.width - dialog.getSize().width) / 2;
            int y = r.y + (r.height - dialog.getSize().height) / 2;
            dialog.setLocation(x, y);
        }
    }

    public static boolean isAppleOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isMacOs = osName.startsWith("mac os x");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Operating System Mac OS? " + isMacOs);
        }
        return isMacOs;
    }

    public static boolean isWindows8() {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean win8 = osName.equals("windows 8");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Operating System Windows 8? " + win8);
        }
        return win8;
    }

    public static Icon getScaledIcon(BufferedImage image, int size, int padding) {
        int h;
        int w = image.getWidth();
        float ratio = (float)w * 1.0f / (float)(h = image.getHeight());
        ratio = ratio < 1.0f ? (float)h * 1.0f / (float)(size - 2 * padding) : (float)w * 1.0f / (float)(size - 2 * padding);
        w = Float.valueOf((float)w / ratio).intValue();
        h = Float.valueOf((float)h / ratio).intValue();
        ImageIcon icon = new ImageIcon(image.getScaledInstance(w, h, 2));
        image.flush();
        return icon;
    }

    public static String convertToMultiline(String orig) {
        return "<html>" + orig.replaceAll("\n", "<br>").replace("\t", "&nbsp; &nbsp; ") + "</html>";
    }

    public static boolean isDevelopmentMode() {
        if (INTERNAL != null) {
            return INTERNAL;
        }
        INTERNAL = System.getenv("debug") != null ? Boolean.TRUE : Boolean.FALSE;
        try {
            File f = new File(System.getProperty("user.home") + File.separatorChar + "stampdev.properties");
            INTERNAL = f.exists();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return INTERNAL;
    }

    public static boolean isBrowsingSupported() {
        Desktop desktop;
        if (BROWSING_SUPPORTED != null) {
            return BROWSING_SUPPORTED;
        }
        boolean result = false;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            result = true;
        }
        BROWSING_SUPPORTED = result;
        return result;
    }

    public static Properties getSettings() {
        if (SETTINGS != null) {
            return SETTINGS;
        }
        SETTINGS = new Properties();
        try {
            InputStream fis = UIHelper.class.getResourceAsStream("/settings.xml");
            SETTINGS.loadFromXML(fis);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading properties", e);
        }
        return SETTINGS;
    }

    public static void setInitialMemory() {
        long memory;
        long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        INITIAL_MEMORY = memory = total - free;
        logger.info("Initializing memory consumed: " + INITIAL_MEMORY + "MB");
    }

    public static long getUsedMemory() {
        long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        return total - free;
    }

    public static float getAvailableMemoryRatio() {
        long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        long max = Runtime.getRuntime().maxMemory() / 0x100000L;
        long image_used = Math.max(total - free - INITIAL_MEMORY, 0L);
        long avail = max - (total - free);
        return image_used > 0L ? (float)(avail / image_used) : 100.0f;
    }

    public static void propagateMouseEvent(MouseEvent e, String methodName) {
        Method method = null;
        try {
            method = "mouseMoved".equals(methodName) || "mouseDragged".equals(methodName) ? MouseMotionListener.class.getMethod(methodName, MouseEvent.class) : MouseListener.class.getMethod(methodName, MouseEvent.class);
            Component source = (Component)e.getSource();
            Container parent = null;
            if (source.getParent() != null) {
                parent = source.getParent();
            }
            if (parent != null && parent.getMouseListeners() != null) {
                MouseEvent e2 = SwingUtilities.convertMouseEvent(source, e, parent);
                for (MouseListener listener : parent.getMouseListeners()) {
                    try {
                        method.invoke((Object)listener, e2);
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception from move event", ex);
                    }
                }
            }
        }
        catch (NoSuchMethodException nsme) {
            logger.log(Level.INFO, "mouseMoved or mouseDragged not found.", nsme);
        }
    }
}

