/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfContentByte;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.javad.pdf.IContentGenerator;
import org.javad.pdf.OutputBounds;
import org.javad.pdf.PositionalContent;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.fonts.PdfFontDefinition;
import org.javad.pdf.model.PageConfiguration;
import org.javad.pdf.util.PdfUtil;
import org.javad.xml.XMLSerializable;

public class TitlePageContent
extends PositionalContent
implements XMLSerializable,
IContentGenerator {
    private String title;
    private String subTitle;
    private Image image;
    private String description;
    private List<String> items = new ArrayList<String>();
    private static final Logger logger = Logger.getLogger(TitlePageContent.class.getName());

    public TitlePageContent(PageConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        if (this.getTitle() != null) {
            writer.writeAttribute("title", this.getTitle());
        }
        if (this.getSubTitle() != null) {
            writer.writeAttribute("subtitle", this.getSubTitle());
        }
        if (this.getDescription() != null) {
            writer.writeAttribute("description", this.getDescription());
        }
        if (!this.getItems().isEmpty()) {
            writer.writeStartElement("content-items");
            for (String s : this.getItems()) {
                writer.writeStartElement("item");
                writer.writeCharacters(s);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    protected com.itextpdf.text.Image determineScaledImage(Image image) throws Exception {
        BufferedImage bImg;
        com.itextpdf.text.Image img = com.itextpdf.text.Image.getInstance(image, Color.WHITE);
        if (image instanceof BufferedImage && (bImg = (BufferedImage)image).getColorModel().getTransparency() == 3) {
            int components = bImg.getColorModel().getColorSpace().getNumComponents();
            int[] transparencyMask = new int[components * 2];
            for (int i = 0; i < transparencyMask.length; i += 2) {
                transparencyMask[i] = 0;
                transparencyMask[i + 1] = 1;
            }
            img.setTransparency(transparencyMask);
        }
        float vRatio = img.getHeight() / PdfUtil.convertFromMillimeters(this.configuration.getHeight() - this.configuration.getMarginTop() - this.configuration.getMarginBottom());
        float hRatio = img.getWidth() / PdfUtil.convertFromMillimeters(this.configuration.getWidth() - this.configuration.getMarginLeft() - this.configuration.getMarginRight());
        float ratio = Math.max(1.0f, Math.max(vRatio / 0.5f, hRatio / 0.5f));
        logger.log(Level.FINE, "Ratio is: {0}", Float.valueOf(ratio));
        img.scaleAbsolute(img.getWidth() / ratio, img.getHeight() / ratio);
        float x = PdfUtil.convertFromMillimeters(this.configuration.getMarginLeft() + (this.configuration.getWidth() - this.configuration.getMarginLeft() - this.configuration.getMarginRight()) / 2.0f) - img.getWidth() / (2.0f * ratio);
        float y = PdfUtil.convertFromMillimeters(this.configuration.getMarginBottom() + (this.configuration.getHeight() - this.configuration.getMarginTop() - this.configuration.getMarginBottom()) / 1.5f) - img.getHeight() / (2.0f * ratio);
        img.setAbsolutePosition(x, y);
        return img;
    }

    private float getWorkablePageHeight() {
        return this.configuration.getHeight() - this.configuration.getMarginBottom() - this.configuration.getMarginTop();
    }

    @Override
    public OutputBounds generate(PdfContentByte content) {
        Font subFont;
        if (this.isSkipped()) {
            return new OutputBounds(this.getX(), this.getY(), 0.0f, 0.0f);
        }
        int maxWidth = 0;
        float top = this.getY();
        if (this.getImage() != null) {
            try {
                com.itextpdf.text.Image img = this.determineScaledImage(this.getImage());
                if (img != null) {
                    content.addImage(img);
                    top -= PdfUtil.convertFromMillimeters(this.getWorkablePageHeight() / 2.0f - this.configuration.getMarginBottom());
                    top = img.getAbsoluteY() - PdfUtil.convertFromMillimeters(25.0f);
                }
            }
            catch (Exception e) {
                logger.log(Level.FINER, "An error occured scaling the image. ", e);
            }
        } else {
            top -= PdfUtil.convertFromMillimeters(this.getWorkablePageHeight() / 3.0f - this.configuration.getMarginBottom());
        }
        content.setColorStroke(BaseColor.BLACK);
        Font f = FontRegistry.getInstance().getFont(PdfFontDefinition.AlbumTitle);
        content.setFontAndSize(f.getBaseFont(), f.getSize());
        content.setHorizontalScaling(110.0f);
        if (this.getTitle() != null && !this.getTitle().isEmpty()) {
            String theTitle = PdfUtil.toUpperCase(this.getTitle());
            maxWidth = (int)f.getBaseFont().getWidthPoint(theTitle, f.getSize());
            top += PdfUtil.renderConstrainedText(content, theTitle, f, this.getX(), top, maxWidth);
        }
        if (this.getSubTitle() != null && !this.getSubTitle().isEmpty()) {
            String sTitle = PdfUtil.toUpperCase(this.getSubTitle());
            Font subFont2 = FontRegistry.getInstance().getFont(PdfFontDefinition.AlbumSubtitle);
            top -= subFont2.getCalculatedSize() + PdfUtil.convertFromMillimeters(3.0f);
            content.setFontAndSize(subFont2.getBaseFont(), subFont2.getSize());
            maxWidth = Math.max(maxWidth, (int)content.getEffectiveStringWidth(sTitle, false));
            top += PdfUtil.renderConstrainedText(content, sTitle, subFont2, this.getX(), top, maxWidth);
        }
        if (this.getDescription() != null && !this.getDescription().isEmpty()) {
            subFont = FontRegistry.getInstance().getFont(PdfFontDefinition.AlbumDescription);
            top -= PdfUtil.convertFromMillimeters(15.0f);
            float width = PdfUtil.convertFromMillimeters((this.configuration.getWidth() - this.configuration.getMarginLeft() - this.configuration.getMarginRight()) / 2.0f);
            content.setFontAndSize(subFont.getBaseFont(), subFont.getSize());
            top += PdfUtil.renderConstrainedText(content, this.getDescription(), subFont, width + PdfUtil.convertFromMillimeters(this.configuration.getMarginLeft()), top, (int)(width * 0.7f));
        }
        if (!this.getItems().isEmpty()) {
            subFont = FontRegistry.getInstance().getFont(PdfFontDefinition.AlbumContents);
            top -= subFont.getCalculatedSize() + PdfUtil.convertFromMillimeters(6.0f);
            content.setFontAndSize(subFont.getBaseFont(), subFont.getSize());
            for (String s : this.getItems()) {
                maxWidth = Math.max(maxWidth, (int)subFont.getBaseFont().getWidthPoint(s, subFont.getSize()));
                PdfUtil.renderConstrainedText(content, s, subFont, this.getX(), top, maxWidth);
                top -= PdfUtil.convertFromMillimeters(3.0f);
            }
        }
        content.setHorizontalScaling(100.0f);
        OutputBounds rect = new OutputBounds(this.getX() - (float)(maxWidth / 2), this.getY(), maxWidth, this.getY() - top);
        return rect;
    }

    public String getTitle() {
        return this.title;
    }

    public Image getImage() {
        return this.image;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getItems() {
        return this.items;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

