/*
 * Decompiled with CFR 0.152.
 */
package org.javad.pdf.fonts.ui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.javad.components.ISettingsPanel;
import org.javad.components.MessagePanel;
import org.javad.components.UIHelper;
import org.javad.pdf.fonts.FontRegistry;
import org.javad.pdf.fonts.PdfFontBean;
import org.javad.pdf.fonts.ui.PdfFontEditor;
import org.javad.stamp.pdf.Resources;
import org.javad.stamp.pdf.events.PdfAppEvent;

public class FontSettingPanel
extends JPanel
implements ISettingsPanel {
    private JPanel panel;
    private JButton editFontUsageButton;
    private MessagePanel messagePanel;
    private JScrollPane scrollPane;
    private JTable table;
    private FontTableModel tableModel;
    private PdfFontEditor editor;
    private static final Logger logger = Logger.getLogger(FontSettingPanel.class.getName());

    public FontSettingPanel() {
        AnnotationProcessor.process((Object)this);
        this.setLayout(new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.UNRELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode("default:grow"), FormFactory.UNRELATED_GAP_ROWSPEC}));
        this.add((Component)this.getMessagePanel(), "2, 2, 3, 1, fill, fill");
        this.add((Component)this.getPanel(), "2, 4, 3, 1, fill, fill");
        this.add((Component)this.getScrollPane(), "2, 5, 3, 1, fill, fill");
    }

    protected TableColumnModel getFontTableColumnModel() {
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        TableColumn usageCol = new TableColumn(FontColumns.Usage.ordinal());
        usageCol.setHeaderValue(FontColumns.Usage.getColumnHeader());
        usageCol.setPreferredWidth(125);
        TableColumn aliasCol = new TableColumn(FontColumns.Alias.ordinal());
        aliasCol.setPreferredWidth(70);
        aliasCol.setHeaderValue(FontColumns.Alias.getColumnHeader());
        TableColumn styleCol = new TableColumn(FontColumns.Style.ordinal());
        styleCol.setHeaderValue(FontColumns.Style.getColumnHeader());
        styleCol.setPreferredWidth(70);
        TableColumn sizeCol = new TableColumn(FontColumns.Size.ordinal());
        sizeCol.setHeaderValue(FontColumns.Size.getColumnHeader());
        sizeCol.setPreferredWidth(25);
        tcm.addColumn(usageCol);
        tcm.addColumn(aliasCol);
        tcm.addColumn(styleCol);
        tcm.addColumn(sizeCol);
        return tcm;
    }

    protected JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setOpaque(false);
            FlowLayout flowLayout = (FlowLayout)this.panel.getLayout();
            flowLayout.setHgap(0);
            flowLayout.setAlignment(0);
            flowLayout.setVgap(0);
            this.panel.setPreferredSize(new Dimension(100, 26));
            this.panel.add(this.getEditFontUsageButton());
        }
        return this.panel;
    }

    protected JButton getEditFontUsageButton() {
        if (this.editFontUsageButton == null) {
            this.editFontUsageButton = new JButton();
            this.editFontUsageButton.setName("btn-fontReference-edit");
            this.editFontUsageButton.setAction(new EditFontUsage());
        }
        return this.editFontUsageButton;
    }

    protected MessagePanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messagePanel = new MessagePanel(UIHelper.convertToMultiline((String)Resources.getString("message.font.helpText")));
        }
        return this.messagePanel;
    }

    protected JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getTable());
        }
        return this.scrollPane;
    }

    protected JTable getTable() {
        if (this.table == null) {
            this.table = new JTable(this.getTableModel());
            this.table.setColumnModel(this.getFontTableColumnModel());
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    FontSettingPanel.this.getEditFontUsageButton().getAction().setEnabled(e.getFirstIndex() >= 0);
                }
            });
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        FontSettingPanel.this.getEditFontUsageButton().getAction().actionPerformed(new ActionEvent(FontSettingPanel.this.getTable(), 5, "edit"));
                    }
                }
            });
        }
        return this.table;
    }

    protected FontTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new FontTableModel();
        }
        return this.tableModel;
    }

    private PdfFontEditor getEditor() {
        if (this.editor == null) {
            this.editor = new PdfFontEditor();
        }
        return this.editor;
    }

    public void loadSettings() {
        Collection<PdfFontBean> beans = FontRegistry.getInstance().getFontBeans();
        this.getTableModel().clear();
        for (PdfFontBean bean : beans) {
            this.getTableModel().addFontBean(bean);
        }
    }

    public void saveSettings() {
        FontRegistry.getInstance().setFontBeans(this.getTableModel().getFontBeans());
    }

    @EventSubscriber(eventClass=PdfAppEvent.class)
    public void handleAppEvent(PdfAppEvent event) {
        if (event.getType() == PdfAppEvent.EventType.FontBeanEdit) {
            PdfFontBean bean = (PdfFontBean)event.getData();
            this.getTableModel().update(bean);
        }
    }

    protected class FontTableModel
    extends AbstractTableModel {
        List<PdfFontBean> fonts = new ArrayList<PdfFontBean>();

        protected FontTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.fonts.size();
        }

        public void clear() {
            this.fonts.clear();
            this.fireTableDataChanged();
        }

        public void addFontBean(PdfFontBean bean) {
            this.setFontBean(this.getRowCount(), bean);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        }

        public PdfFontBean getFontBean(int row) {
            return this.fonts.get(row);
        }

        public void update(PdfFontBean bean) {
            int row = 0;
            for (PdfFontBean b : this.fonts) {
                if (b.equals(bean)) {
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
                ++row;
            }
        }

        public void setFontBean(int row, PdfFontBean bean) {
            if (row < this.fonts.size()) {
                this.fonts.set(row, bean);
            } else {
                this.fonts.add(bean);
            }
            this.fireTableRowsInserted(row, row);
        }

        public List<PdfFontBean> getFontBeans() {
            return this.fonts;
        }

        @Override
        public int getColumnCount() {
            return FontColumns.values().length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FontColumns col = FontColumns.values()[columnIndex];
            PdfFontBean bean = this.fonts.get(rowIndex);
            switch (col) {
                case Usage: {
                    return bean.getFontDefinition().toString();
                }
                case Alias: {
                    if (bean.isSystem()) {
                        return bean.getFontFamily();
                    }
                    if (bean.getFontMapping() != null) {
                        return bean.getFontMapping().getFontAlias();
                    }
                }
                case Style: {
                    return this.getStyle(bean);
                }
                case Size: {
                    DecimalFormat format = new DecimalFormat("0.0##");
                    return format.format(bean.getSize());
                }
            }
            return "";
        }

        private String getStyle(PdfFontBean bean) {
            StringBuilder str = new StringBuilder("");
            if (bean.getStyle() < 0 || bean.getStyle() == 0) {
                str.append(Resources.getString("table.style.normal"));
            } else {
                if (bean.isBold()) {
                    str.append(Resources.getString("table.style.bold"));
                }
                if (bean.isItalic()) {
                    if (str.length() > 0) {
                        str.append(", ");
                    }
                    str.append(Resources.getString("table.style.italic"));
                }
                if (bean.isUnderline()) {
                    if (str.length() > 0) {
                        str.append(", ");
                    }
                    str.append(Resources.getString("table.style.underline"));
                }
            }
            return str.toString();
        }
    }

    static enum FontColumns {
        Usage,
        Alias,
        Style,
        Size;


        String getColumnHeader() {
            switch (this) {
                case Usage: {
                    return Resources.getString("table.header.fontUsage");
                }
                case Alias: {
                    return Resources.getString("table.header.fontAlias");
                }
                case Style: {
                    return Resources.getString("table.header.fontStyle");
                }
                case Size: {
                    return Resources.getString("table.header.fontSize");
                }
            }
            return "";
        }
    }

    class EditFontUsage
    extends AbstractAction {
        EditFontUsage() {
            this.putValue("SwingLargeIconKey", Resources.getIcon("icon.editFont.small"));
            this.putValue("ShortDescription", Resources.getString("label.fontEdit.tooltip"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = FontSettingPanel.this.getTable().getSelectedRow();
            if (row >= 0) {
                PdfFontBean bean = FontSettingPanel.this.getTableModel().getFontBean(row);
                FontSettingPanel.this.getEditor().initialize(bean, FontRegistry.getInstance().getFontMappings());
                FontSettingPanel.this.getEditor().setVisible(true);
            } else {
                logger.warning("The edit action was performed on a non-selected row.");
            }
        }
    }
}

